##############################################################################
##
## Zen_PowerShell_Script_strings.psd1
##
## by Actian Corporation (http://www.actian.com/zen)
##
## Localized strings for Actian Zen PowerShell scripts.
##
##############################################################################
@{
    ## Information message strings.    
    infoRunning="Running {0} {1}..."
    infoLooking="...looking for installed {0} product."
    infoZenInfo="...found version {0} installed."
    infoVisualStudioInfo="...found Visual Studio version '{0}' at '{1}'."
    infoInstallingVsixPkg="...please wait, importing VS Extension package for PSQL ADO.NET Provider Data Tools."
    infoInstalledVsixPkgLatestWithLog="   ...import complete, see the log file %temp%\{0} for details."
    infoInstalledVsixPkgLatestNoLog="   ...import complete."
    infoRemovingVsixPkg="...please wait, removing VS Extension package for PSQL ADO.NET Provider Data Tools."
    infoRemovedVsixPkgLatestWithLog="   ...removal complete, see {0} in %temp% folder for details."
    infoRemovedVsixPkgLatestNoLog="   ...removal complete."
    infoAddedModelFirstIncludeTemplates="...successfully imported the Entity Framework Model First include templates."
    infoAddedModelFirstT4Templates="...successfully imported the Entity Framework Model First T4 templates."
    infoRemovedModelFirstIncludeTemplates="...successfully removed the Entity Framework Model First include templates."
    infoRemovedModelFirstT4Templates="...successfully removed the Entity Framework Model First T4 templates."
    infoEnd="Finished running {0} {1}!"
    
    ## Warning message strings.
    warnNoTemplates="WARNING: The script was unable to copy the Model First templates to the Entity Framework Tools folder ({0})."
    
    ## Error message strings.
    errMustBeAdmin="ERROR: The current Windows PowerShell session is not running as Administrator. Start Windows PowerShell by  using the Run as Administrator option, and then try running the script again."
    errMustBePS64onWin64="ERROR: The current Windows PowerShell session is a 32-bit process. On 64-bit Windows, please run the install from a 64-bit PowerShell process."
    errNoZenFound="ERROR: Unable to locate Zen installed on the target system. Please install Zen and then restart the PSQL ADO.NET Provider Data Tools installation."
    errWrongZenVer="ERROR: The PSQL ADO.NET Provider Data Tools installation requires Zen v{0}.x or later.  Please install Zen v{0}.x or later and then restart the PSQL ADO.NET Provider Data Tools installation."
    errNoVSFound="ERROR: Unable to locate the install folder for Visual Studio.  Please verify Visual Studio {0} is installed and restart this script."
    errNoVSIXInstaller="ERROR: Unable to locate the Visual Studio VSIXInstaller utility. The PSQL ADO.NET Provider Data Tools VSIX package cannot be imported into Visual Studio."
    errVsixInstallWithLog="ERROR: Unable to import the PSQL ADO.NET Provider Data Tools VSIX package into Visual Studio. Check the contents of log file located in the TEMP folder{0}."
    errVsixInstallNoLog="ERROR: Unable to import the PSQL ADO.NET Provider Data Tools VSIX package into Visual Studio."
    errVsixUninstallWithLog="ERROR: Unable to remove the PSQL ADO.NET Provider Data Tools VSIX package from Visual Studio. Check the contents of log file located in the TEMP folder{0}."
    errVsixUninstallNoLog="ERROR: Unable to remove the PSQL ADO.NET Provider Data Tools VSIX package from Visual Studio."
    errUnknown="ERROR: The script encountered an unknown error and will now exit."
}
# SIG # Begin signature block
# MIIpUgYJKoZIhvcNAQcCoIIpQzCCKT8CAQExDzANBglghkgBZQMEAgEFADB5Bgor
# BgEEAYI3AgEEoGswaTA0BgorBgEEAYI3AgEeMCYCAwEAAAQQH8w7YFlLCE63JNLG
# KX7zUQIBAAIBAAIBAAIBAAIBADAxMA0GCWCGSAFlAwQCAQUABCDeJ6uehFqpXMyG
# yTcythTN6S4uqwfiY9NqFjxQoK3vNaCCDiowggawMIIEmKADAgECAhAIrUCyYNKc
# TJ9ezam9k67ZMA0GCSqGSIb3DQEBDAUAMGIxCzAJBgNVBAYTAlVTMRUwEwYDVQQK
# EwxEaWdpQ2VydCBJbmMxGTAXBgNVBAsTEHd3dy5kaWdpY2VydC5jb20xITAfBgNV
# BAMTGERpZ2lDZXJ0IFRydXN0ZWQgUm9vdCBHNDAeFw0yMTA0MjkwMDAwMDBaFw0z
# NjA0MjgyMzU5NTlaMGkxCzAJBgNVBAYTAlVTMRcwFQYDVQQKEw5EaWdpQ2VydCwg
# SW5jLjFBMD8GA1UEAxM4RGlnaUNlcnQgVHJ1c3RlZCBHNCBDb2RlIFNpZ25pbmcg
# UlNBNDA5NiBTSEEzODQgMjAyMSBDQTEwggIiMA0GCSqGSIb3DQEBAQUAA4ICDwAw
# ggIKAoICAQDVtC9C0CiteLdd1TlZG7GIQvUzjOs9gZdwxbvEhSYwn6SOaNhc9es0
# JAfhS0/TeEP0F9ce2vnS1WcaUk8OoVf8iJnBkcyBAz5NcCRks43iCH00fUyAVxJr
# Q5qZ8sU7H/Lvy0daE6ZMswEgJfMQ04uy+wjwiuCdCcBlp/qYgEk1hz1RGeiQIXhF
# LqGfLOEYwhrMxe6TSXBCMo/7xuoc82VokaJNTIIRSFJo3hC9FFdd6BgTZcV/sk+F
# LEikVoQ11vkunKoAFdE3/hoGlMJ8yOobMubKwvSnowMOdKWvObarYBLj6Na59zHh
# 3K3kGKDYwSNHR7OhD26jq22YBoMbt2pnLdK9RBqSEIGPsDsJ18ebMlrC/2pgVItJ
# wZPt4bRc4G/rJvmM1bL5OBDm6s6R9b7T+2+TYTRcvJNFKIM2KmYoX7BzzosmJQay
# g9Rc9hUZTO1i4F4z8ujo7AqnsAMrkbI2eb73rQgedaZlzLvjSFDzd5Ea/ttQokbI
# YViY9XwCFjyDKK05huzUtw1T0PhH5nUwjewwk3YUpltLXXRhTT8SkXbev1jLchAp
# QfDVxW0mdmgRQRNYmtwmKwH0iU1Z23jPgUo+QEdfyYFQc4UQIyFZYIpkVMHMIRro
# OBl8ZhzNeDhFMJlP/2NPTLuqDQhTQXxYPUez+rbsjDIJAsxsPAxWEQIDAQABo4IB
# WTCCAVUwEgYDVR0TAQH/BAgwBgEB/wIBADAdBgNVHQ4EFgQUaDfg67Y7+F8Rhvv+
# YXsIiGX0TkIwHwYDVR0jBBgwFoAU7NfjgtJxXWRM3y5nP+e6mK4cD08wDgYDVR0P
# AQH/BAQDAgGGMBMGA1UdJQQMMAoGCCsGAQUFBwMDMHcGCCsGAQUFBwEBBGswaTAk
# BggrBgEFBQcwAYYYaHR0cDovL29jc3AuZGlnaWNlcnQuY29tMEEGCCsGAQUFBzAC
# hjVodHRwOi8vY2FjZXJ0cy5kaWdpY2VydC5jb20vRGlnaUNlcnRUcnVzdGVkUm9v
# dEc0LmNydDBDBgNVHR8EPDA6MDigNqA0hjJodHRwOi8vY3JsMy5kaWdpY2VydC5j
# b20vRGlnaUNlcnRUcnVzdGVkUm9vdEc0LmNybDAcBgNVHSAEFTATMAcGBWeBDAED
# MAgGBmeBDAEEATANBgkqhkiG9w0BAQwFAAOCAgEAOiNEPY0Idu6PvDqZ01bgAhql
# +Eg08yy25nRm95RysQDKr2wwJxMSnpBEn0v9nqN8JtU3vDpdSG2V1T9J9Ce7FoFF
# UP2cvbaF4HZ+N3HLIvdaqpDP9ZNq4+sg0dVQeYiaiorBtr2hSBh+3NiAGhEZGM1h
# mYFW9snjdufE5BtfQ/g+lP92OT2e1JnPSt0o618moZVYSNUa/tcnP/2Q0XaG3Ryw
# YFzzDaju4ImhvTnhOE7abrs2nfvlIVNaw8rpavGiPttDuDPITzgUkpn13c5Ubdld
# AhQfQDN8A+KVssIhdXNSy0bYxDQcoqVLjc1vdjcshT8azibpGL6QB7BDf5WIIIJw
# 8MzK7/0pNVwfiThV9zeKiwmhywvpMRr/LhlcOXHhvpynCgbWJme3kuZOX956rEnP
# LqR0kq3bPKSchh/jwVYbKyP/j7XqiHtwa+aguv06P0WmxOgWkVKLQcBIhEuWTatE
# QOON8BUozu3xGFYHKi8QxAwIZDwzj64ojDzLj4gLDb879M4ee47vtevLt/B3E+bn
# KD+sEq6lLyJsQfmCXBVmzGwOysWGw/YmMwwHS6DTBwJqakAwSEs0qFEgu60bhQji
# WQ1tygVQK+pKHJ6l/aCnHwZ05/LWUpD9r4VIIflXO7ScA+2GRfS0YW6/aOImYIbq
# yK+p/pQd52MbOoZWeE4wggdyMIIFWqADAgECAhALug4gRzX+ySpZsBzdR9OMMA0G
# CSqGSIb3DQEBCwUAMGkxCzAJBgNVBAYTAlVTMRcwFQYDVQQKEw5EaWdpQ2VydCwg
# SW5jLjFBMD8GA1UEAxM4RGlnaUNlcnQgVHJ1c3RlZCBHNCBDb2RlIFNpZ25pbmcg
# UlNBNDA5NiBTSEEzODQgMjAyMSBDQTEwHhcNMjMwNDI0MDAwMDAwWhcNMjYwNDIz
# MjM1OTU5WjB6MQswCQYDVQQGEwJVUzEOMAwGA1UECBMFVGV4YXMxEzARBgNVBAcT
# ClJvdW5kIFJvY2sxGzAZBgNVBAoTEkFjdGlhbiBDb3Jwb3JhdGlvbjEMMAoGA1UE
# CxMDWmVuMRswGQYDVQQDExJBY3RpYW4gQ29ycG9yYXRpb24wggIiMA0GCSqGSIb3
# DQEBAQUAA4ICDwAwggIKAoICAQCmrbJewixh8zYkjt5G34WYugoGnAfUHCzJmXGn
# sNqZ7jSNZR8Fy3Z9aFFUkwYULY2CQxNNC/GSdnt1lB0TM1ggSido3ttaJ2FaUD9F
# oi1keyc9pR8cKjtt8R1go+BNHy4MIPrr6HbI9ObXxGwP5WVAW72jaOW2rJcGOKuB
# wG642zwhAA4wJxRJKV394PxuUsLmqqyarb8wdvAhZJUP0OZiV5ERJ0ZglBv4qdPt
# e0u4pZCpbhhlPEptFHX2bEdY9eKAeqZClenQyzJqJkOgpeGPjoN8mh1FLeLlwSjs
# AdiAL4KBHyAQb2kGEU7uJaKpyoq1VxSerNWtZUmihQMP9EJg7cHSZPJNj2HBhhOR
# r1NbEzyZjx2I1G/Ib69A0R6CaiEXyJnLJxg4R5VazeM87YS23ML0jFyDiCzfnQp5
# W+ls8i0MHhqqVqpsRZPViHHjJtNpcAR7KsbRrlsXL9c5kMqNvKxDvZeV0oVSECAd
# 3Djtr0pfSvXU0eKIl8i3LDimc+VcTtbbfs93TGDyVaNb9uDTlAKhk46PaYhamNqr
# ZCkWWiNSdnglito6wKaOa91AnBN2WbQxOEEpz8UEvNPYM/+HGYIwefXspJz4wvAB
# yB9AYShQ4oUGPnQ/+fPWZFZ/yTi7Gpb69FedVltEiL7A+3Ds7UKZ/269YhTQYSGh
# P5R8HQIDAQABo4ICAzCCAf8wHwYDVR0jBBgwFoAUaDfg67Y7+F8Rhvv+YXsIiGX0
# TkIwHQYDVR0OBBYEFLZN9fT8GcYstZ/eHlOoSwqtoRPtMA4GA1UdDwEB/wQEAwIH
# gDATBgNVHSUEDDAKBggrBgEFBQcDAzCBtQYDVR0fBIGtMIGqMFOgUaBPhk1odHRw
# Oi8vY3JsMy5kaWdpY2VydC5jb20vRGlnaUNlcnRUcnVzdGVkRzRDb2RlU2lnbmlu
# Z1JTQTQwOTZTSEEzODQyMDIxQ0ExLmNybDBToFGgT4ZNaHR0cDovL2NybDQuZGln
# aWNlcnQuY29tL0RpZ2lDZXJ0VHJ1c3RlZEc0Q29kZVNpZ25pbmdSU0E0MDk2U0hB
# Mzg0MjAyMUNBMS5jcmwwPgYDVR0gBDcwNTAzBgZngQwBBAEwKTAnBggrBgEFBQcC
# ARYbaHR0cDovL3d3dy5kaWdpY2VydC5jb20vQ1BTMIGUBggrBgEFBQcBAQSBhzCB
# hDAkBggrBgEFBQcwAYYYaHR0cDovL29jc3AuZGlnaWNlcnQuY29tMFwGCCsGAQUF
# BzAChlBodHRwOi8vY2FjZXJ0cy5kaWdpY2VydC5jb20vRGlnaUNlcnRUcnVzdGVk
# RzRDb2RlU2lnbmluZ1JTQTQwOTZTSEEzODQyMDIxQ0ExLmNydDAJBgNVHRMEAjAA
# MA0GCSqGSIb3DQEBCwUAA4ICAQCWGybROBuJGQ2OT6P6pJtQptFx2fprQP+Ttb5L
# 97xCPKnI72HljOJUKIiC+QJCqolKBFvtxbtzsFap4fXkBQVsDcrNijMLjX5IxAFv
# l2N7kQ03POGihblkie2n+HgX0Frnd9PrJxSBalzylmsNtHCvhgwdnSZzPBb9pGW8
# zLJjsEiFGOPvH6UP2TfLNZHpys10DpM5U44mw9h034EHuNafF4Dbxp7heu58jtWS
# QDzFmVe2+4/tk5eHAHx0IuhAWYhtTlygMZK54oOp0DHSRnQKMfeqa7XUS5pwVFR1
# MLbZETlr8SS2Y5AnPHKGE4vFOVXOznwEmYUTj/+bRnL0cm7ndeLsAfHVQsJjmF4K
# gcNaqMaAuAV80M4LrFt+bV0JUC83cu2RmrMKQyO1FEm7yp7VcQniVIbwBv1w+rOh
# aKAW+6Zoj4n6QrpYpdIdjs5gY2crwzUs5wst16bkVHQh+vFX6KCax41RcXTvLTbI
# T4Hnz3zSOTQKLHunfQs4/QyUd8LoAPnKJGH9Dwgs3BESIbFcdLDuzQ9Gza9dUaBX
# eswMXJug5CaO8gblx99JD6jZBGV6hUb9+72UTKWy+3Yv2KkFPmPLxUqyrAoG+MR9
# DOEeMZP10Qjfu7OeRZoR6oSeWLQJUUS2zybxFq4Xxx6C5v58ZUtO9gOjLhrwB72m
# mPuBWDGCGn4wghp6AgEBMH0waTELMAkGA1UEBhMCVVMxFzAVBgNVBAoTDkRpZ2lD
# ZXJ0LCBJbmMuMUEwPwYDVQQDEzhEaWdpQ2VydCBUcnVzdGVkIEc0IENvZGUgU2ln
# bmluZyBSU0E0MDk2IFNIQTM4NCAyMDIxIENBMQIQC7oOIEc1/skqWbAc3UfTjDAN
# BglghkgBZQMEAgEFAKCBljAZBgkqhkiG9w0BCQMxDAYKKwYBBAGCNwIBBDAcBgor
# BgEEAYI3AgELMQ4wDAYKKwYBBAGCNwIBFTAqBgorBgEEAYI3AgEMMRwwGqEYgBZo
# dHRwOlxcd3d3LmFjdGlhbi5jb20gMC8GCSqGSIb3DQEJBDEiBCAofDCgG8yxQIdB
# 5DTH3H7HT73gcVItv6WCtm54ixbASjANBgkqhkiG9w0BAQEFAASCAgBm8Pekufbk
# nU/Ech+gv55YugAIIaOm6snErgzvd5h0ImsuCaY0pqZWL3C3yjmL+EUvv6GH2uOA
# ztpP72PjPTSaBEdM6pDgaUKX9lyo3dWfLEPftWoo5EYGBF0NlYf91Nv47kyl6Xs5
# PYdvGz3OyyqOeSImmAYrSBfIP4DH5c/GmJmX1UqPeGJZht8ulpvgiGv/B55JMHYk
# wN+/QekNTqZut1Rr4snDvqGu68UMWuM8JE9uwOjKWAiOCq67X5ReiafmaaX4Bgqx
# nZPPrFzTPLNSWqjGrPRVLmN2A81TkdLien738sxTXOTegvmtFmaOVs3D6lp54It9
# ue4twgCQfI2QSoEapyQGfhAYT/TxH/pHifuqbUn80UDcjLqb1XbhUF0ovCLBXFqK
# NUFJy2rw90pAgkxmlV6+G6oOjtXvuspbE72DZ71R6089FvIh/IQpq6v8FQEUIyW0
# 6fz9ZYvCHnZ8CTcTmaR2GuOZa6QAyqtNOFA+gJ0pqekEmW0nlvbkEj6ppl0A3XaY
# QUsX/PEWuTa+NnSBJgssy/+j4QgRDP7YcJuvdOqsNHzb9aDSBG2/lTOjZv/aZP4A
# XeI6u675CuSfN1R2lXhIF+UC3pNz3tRcmA0YR4PsSAj/UwbqiG1XwrOpfk1BWtSH
# oKH7J/OE/2CguiWtqEU8C2B79eqOhZhBjaGCFzkwghc1BgorBgEEAYI3AwMBMYIX
# JTCCFyEGCSqGSIb3DQEHAqCCFxIwghcOAgEDMQ8wDQYJYIZIAWUDBAIBBQAwdwYL
# KoZIhvcNAQkQAQSgaARmMGQCAQEGCWCGSAGG/WwHATAxMA0GCWCGSAFlAwQCAQUA
# BCB8J2pZjVZ7rO1i26krw9pPmNjOP319oeX+hnpEUmtqGwIQdNkK3fTOaKJFM+zD
# SHsD8xgPMjAyNTA2MjcwMTA5MDhaoIITAzCCBrwwggSkoAMCAQICEAuuZrxaun+V
# h8b56QTjMwQwDQYJKoZIhvcNAQELBQAwYzELMAkGA1UEBhMCVVMxFzAVBgNVBAoT
# DkRpZ2lDZXJ0LCBJbmMuMTswOQYDVQQDEzJEaWdpQ2VydCBUcnVzdGVkIEc0IFJT
# QTQwOTYgU0hBMjU2IFRpbWVTdGFtcGluZyBDQTAeFw0yNDA5MjYwMDAwMDBaFw0z
# NTExMjUyMzU5NTlaMEIxCzAJBgNVBAYTAlVTMREwDwYDVQQKEwhEaWdpQ2VydDEg
# MB4GA1UEAxMXRGlnaUNlcnQgVGltZXN0YW1wIDIwMjQwggIiMA0GCSqGSIb3DQEB
# AQUAA4ICDwAwggIKAoICAQC+anOf9pUhq5Ywultt5lmjtej9kR8YxIg7apnjpcH9
# CjAgQxK+CMR0Rne/i+utMeV5bUlYYSuuM4vQngvQepVHVzNLO9RDnEXvPghCaft0
# djvKKO+hDu6ObS7rJcXa/UKvNminKQPTv/1+kBPgHGlP28mgmoCw/xi6FG9+Un1h
# 4eN6zh926SxMe6We2r1Z6VFZj75MU/HNmtsgtFjKfITLutLWUdAoWle+jYZ49+wx
# GE1/UXjWfISDmHuI5e/6+NfQrxGFSKx+rDdNMsePW6FLrphfYtk/FLihp/feun0e
# V+pIF496OVh4R1TvjQYpAztJpVIfdNsEvxHofBf1BWkadc+Up0Th8EifkEEWdX4r
# A/FE1Q0rqViTbLVZIqi6viEk3RIySho1XyHLIAOJfXG5PEppc3XYeBH7xa6VTZ3r
# OHNeiYnY+V4j1XbJ+Z9dI8ZhqcaDHOoj5KGg4YuiYx3eYm33aebsyF6eD9MF5IDb
# PgjvwmnAalNEeJPvIeoGJXaeBQjIK13SlnzODdLtuThALhGtyconcVuPI8AaiCai
# JnfdzUcb3dWnqUnjXkRFwLtsVAxFvGqsxUA2Jq/WTjbnNjIUzIs3ITVC6VBKAOlb
# 2u29Vwgfta8b2ypi6n2PzP0nVepsFk8nlcuWfyZLzBaZ0MucEdeBiXL+nUOGhCjl
# +QIDAQABo4IBizCCAYcwDgYDVR0PAQH/BAQDAgeAMAwGA1UdEwEB/wQCMAAwFgYD
# VR0lAQH/BAwwCgYIKwYBBQUHAwgwIAYDVR0gBBkwFzAIBgZngQwBBAIwCwYJYIZI
# AYb9bAcBMB8GA1UdIwQYMBaAFLoW2W1NhS9zKXaaL3WMaiCPnshvMB0GA1UdDgQW
# BBSfVywDdw4oFZBmpWNe7k+SH3agWzBaBgNVHR8EUzBRME+gTaBLhklodHRwOi8v
# Y3JsMy5kaWdpY2VydC5jb20vRGlnaUNlcnRUcnVzdGVkRzRSU0E0MDk2U0hBMjU2
# VGltZVN0YW1waW5nQ0EuY3JsMIGQBggrBgEFBQcBAQSBgzCBgDAkBggrBgEFBQcw
# AYYYaHR0cDovL29jc3AuZGlnaWNlcnQuY29tMFgGCCsGAQUFBzAChkxodHRwOi8v
# Y2FjZXJ0cy5kaWdpY2VydC5jb20vRGlnaUNlcnRUcnVzdGVkRzRSU0E0MDk2U0hB
# MjU2VGltZVN0YW1waW5nQ0EuY3J0MA0GCSqGSIb3DQEBCwUAA4ICAQA9rR4fdplb
# 4ziEEkfZQ5H2EdubTggd0ShPz9Pce4FLJl6reNKLkZd5Y/vEIqFWKt4oKcKz7wZm
# Xa5VgW9B76k9NJxUl4JlKwyjUkKhk3aYx7D8vi2mpU1tKlY71AYXB8wTLrQeh83p
# XnWwwsxc1Mt+FWqz57yFq6laICtKjPICYYf/qgxACHTvypGHrC8k1TqCeHk6u4I/
# VBQC9VK7iSpU5wlWjNlHlFFv/M93748YTeoXU/fFa9hWJQkuzG2+B7+bMDvmgF8V
# lJt1qQcl7YFUMYgZU1WM6nyw23vT6QSgwX5Pq2m0xQ2V6FJHu8z4LXe/371k5QrN
# 9FQBhLLISZi2yemW0P8ZZfx4zvSWzVXpAb9k4Hpvpi6bUe8iK6WonUSV6yPlMwer
# wJZP/Gtbu3CKldMnn+LmmRTkTXpFIEB06nXZrDwhCGED+8RsWQSIXZpuG4WLFQOh
# tloDRWGoCwwc6ZpPddOFkM2LlTbMcqFSzm4cd0boGhBq7vkqI1uHRz6Fq1IX7TaR
# QuR+0BGOzISkcqwXu7nMpFu3mgrlgbAW+BzikRVQ3K2YHcGkiKjA4gi4OA/kz1YC
# sdhIBHXqBzR0/Zd2QwQ/l4Gxftt/8wY3grcc/nS//TVkej9nmUYu83BDtccHHXKi
# bMs/yXHhDXNkoPIdynhVAku7aRZOwqw6pDCCBq4wggSWoAMCAQICEAc2N7ckVHzY
# R6z9KGYqXlswDQYJKoZIhvcNAQELBQAwYjELMAkGA1UEBhMCVVMxFTATBgNVBAoT
# DERpZ2lDZXJ0IEluYzEZMBcGA1UECxMQd3d3LmRpZ2ljZXJ0LmNvbTEhMB8GA1UE
# AxMYRGlnaUNlcnQgVHJ1c3RlZCBSb290IEc0MB4XDTIyMDMyMzAwMDAwMFoXDTM3
# MDMyMjIzNTk1OVowYzELMAkGA1UEBhMCVVMxFzAVBgNVBAoTDkRpZ2lDZXJ0LCBJ
# bmMuMTswOQYDVQQDEzJEaWdpQ2VydCBUcnVzdGVkIEc0IFJTQTQwOTYgU0hBMjU2
# IFRpbWVTdGFtcGluZyBDQTCCAiIwDQYJKoZIhvcNAQEBBQADggIPADCCAgoCggIB
# AMaGNQZJs8E9cklRVcclA8TykTepl1Gh1tKD0Z5Mom2gsMyD+Vr2EaFEFUJfpIjz
# aPp985yJC3+dH54PMx9QEwsmc5Zt+FeoAn39Q7SE2hHxc7Gz7iuAhIoiGN/r2j3E
# F3+rGSs+QtxnjupRPfDWVtTnKC3r07G1decfBmWNlCnT2exp39mQh0YAe9tEQYnc
# fGpXevA3eZ9drMvohGS0UvJ2R/dhgxndX7RUCyFobjchu0CsX7LeSn3O9TkSZ+8O
# pWNs5KbFHc02DVzV5huowWR0QKfAcsW6Th+xtVhNef7Xj3OTrCw54qVI1vCwMROp
# VymWJy71h6aPTnYVVSZwmCZ/oBpHIEPjQ2OAe3VuJyWQmDo4EbP29p7mO1vsgd4i
# FNmCKseSv6De4z6ic/rnH1pslPJSlRErWHRAKKtzQ87fSqEcazjFKfPKqpZzQmif
# tkaznTqj1QPgv/CiPMpC3BhIfxQ0z9JMq++bPf4OuGQq+nUoJEHtQr8FnGZJUlD0
# UfM2SU2LINIsVzV5K6jzRWC8I41Y99xh3pP+OcD5sjClTNfpmEpYPtMDiP6zj9Ne
# S3YSUZPJjAw7W4oiqMEmCPkUEBIDfV8ju2TjY+Cm4T72wnSyPx4JduyrXUZ14mCj
# WAkBKAAOhFTuzuldyF4wEr1GnrXTdrnSDmuZDNIztM2xAgMBAAGjggFdMIIBWTAS
# BgNVHRMBAf8ECDAGAQH/AgEAMB0GA1UdDgQWBBS6FtltTYUvcyl2mi91jGogj57I
# bzAfBgNVHSMEGDAWgBTs1+OC0nFdZEzfLmc/57qYrhwPTzAOBgNVHQ8BAf8EBAMC
# AYYwEwYDVR0lBAwwCgYIKwYBBQUHAwgwdwYIKwYBBQUHAQEEazBpMCQGCCsGAQUF
# BzABhhhodHRwOi8vb2NzcC5kaWdpY2VydC5jb20wQQYIKwYBBQUHMAKGNWh0dHA6
# Ly9jYWNlcnRzLmRpZ2ljZXJ0LmNvbS9EaWdpQ2VydFRydXN0ZWRSb290RzQuY3J0
# MEMGA1UdHwQ8MDowOKA2oDSGMmh0dHA6Ly9jcmwzLmRpZ2ljZXJ0LmNvbS9EaWdp
# Q2VydFRydXN0ZWRSb290RzQuY3JsMCAGA1UdIAQZMBcwCAYGZ4EMAQQCMAsGCWCG
# SAGG/WwHATANBgkqhkiG9w0BAQsFAAOCAgEAfVmOwJO2b5ipRCIBfmbW2CFC4bAY
# LhBNE88wU86/GPvHUF3iSyn7cIoNqilp/GnBzx0H6T5gyNgL5Vxb122H+oQgJTQx
# Z822EpZvxFBMYh0MCIKoFr2pVs8Vc40BIiXOlWk/R3f7cnQU1/+rT4osequFzUNf
# 7WC2qk+RZp4snuCKrOX9jLxkJodskr2dfNBwCnzvqLx1T7pa96kQsl3p/yhUifDV
# inF2ZdrM8HKjI/rAJ4JErpknG6skHibBt94q6/aesXmZgaNWhqsKRcnfxI2g55j7
# +6adcq/Ex8HBanHZxhOACcS2n82HhyS7T6NJuXdmkfFynOlLAlKnN36TU6w7HQhJ
# D5TNOXrd/yVjmScsPT9rp/Fmw0HNT7ZAmyEhQNC3EyTN3B14OuSereU0cZLXJmvk
# OHOrpgFPvT87eK1MrfvElXvtCl8zOYdBeHo46Zzh3SP9HSjTx/no8Zhf+yvYfvJG
# nXUsHicsJttvFXseGYs2uJPU5vIXmVnKcPA3v5gA3yAWTyf7YGcWoWa63VXAOimG
# sJigK+2VQbc61RWYMbRiCQ8KvYHZE/6/pNHzV9m8BPqC3jLfBInwAM1dwvnQI38A
# C+R2AibZ8GV2QqYphwlHK+Z/GqSFD/yYlvZVVCsfgPrA8g4r5db7qS9EFUrnEw4d
# 2zc4GqEr9u3WfPwwggWNMIIEdaADAgECAhAOmxiO+dAt5+/bUOIIQBhaMA0GCSqG
# SIb3DQEBDAUAMGUxCzAJBgNVBAYTAlVTMRUwEwYDVQQKEwxEaWdpQ2VydCBJbmMx
# GTAXBgNVBAsTEHd3dy5kaWdpY2VydC5jb20xJDAiBgNVBAMTG0RpZ2lDZXJ0IEFz
# c3VyZWQgSUQgUm9vdCBDQTAeFw0yMjA4MDEwMDAwMDBaFw0zMTExMDkyMzU5NTla
# MGIxCzAJBgNVBAYTAlVTMRUwEwYDVQQKEwxEaWdpQ2VydCBJbmMxGTAXBgNVBAsT
# EHd3dy5kaWdpY2VydC5jb20xITAfBgNVBAMTGERpZ2lDZXJ0IFRydXN0ZWQgUm9v
# dCBHNDCCAiIwDQYJKoZIhvcNAQEBBQADggIPADCCAgoCggIBAL/mkHNo3rvkXUo8
# MCIwaTPswqclLskhPfKK2FnC4SmnPVirdprNrnsbhA3EMB/zG6Q4FutWxpdtHauy
# efLKEdLkX9YFPFIPUh/GnhWlfr6fqVcWWVVyr2iTcMKyunWZanMylNEQRBAu34Lz
# B4TmdDttceItDBvuINXJIB1jKS3O7F5OyJP4IWGbNOsFxl7sWxq868nPzaw0QF+x
# embud8hIqGZXV59UWI4MK7dPpzDZVu7Ke13jrclPXuU15zHL2pNe3I6PgNq2kZhA
# kHnDeMe2scS1ahg4AxCN2NQ3pC4FfYj1gj4QkXCrVYJBMtfbBHMqbpEBfCFM1Lyu
# GwN1XXhm2ToxRJozQL8I11pJpMLmqaBn3aQnvKFPObURWBf3JFxGj2T3wWmIdph2
# PVldQnaHiZdpekjw4KISG2aadMreSx7nDmOu5tTvkpI6nj3cAORFJYm2mkQZK37A
# lLTSYW3rM9nF30sEAMx9HJXDj/chsrIRt7t/8tWMcCxBYKqxYxhElRp2Yn72gLD7
# 6GSmM9GJB+G9t+ZDpBi4pncB4Q+UDCEdslQpJYls5Q5SUUd0viastkF13nqsX40/
# ybzTQRESW+UQUOsxxcpyFiIJ33xMdT9j7CFfxCBRa2+xq4aLT8LWRV+dIPyhHsXA
# j6KxfgommfXkaS+YHS312amyHeUbAgMBAAGjggE6MIIBNjAPBgNVHRMBAf8EBTAD
# AQH/MB0GA1UdDgQWBBTs1+OC0nFdZEzfLmc/57qYrhwPTzAfBgNVHSMEGDAWgBRF
# 66Kv9JLLgjEtUYunpyGd823IDzAOBgNVHQ8BAf8EBAMCAYYweQYIKwYBBQUHAQEE
# bTBrMCQGCCsGAQUFBzABhhhodHRwOi8vb2NzcC5kaWdpY2VydC5jb20wQwYIKwYB
# BQUHMAKGN2h0dHA6Ly9jYWNlcnRzLmRpZ2ljZXJ0LmNvbS9EaWdpQ2VydEFzc3Vy
# ZWRJRFJvb3RDQS5jcnQwRQYDVR0fBD4wPDA6oDigNoY0aHR0cDovL2NybDMuZGln
# aWNlcnQuY29tL0RpZ2lDZXJ0QXNzdXJlZElEUm9vdENBLmNybDARBgNVHSAECjAI
# MAYGBFUdIAAwDQYJKoZIhvcNAQEMBQADggEBAHCgv0NcVec4X6CjdBs9thbX979X
# B72arKGHLOyFXqkauyL4hxppVCLtpIh3bb0aFPQTSnovLbc47/T/gLn4offyct4k
# vFIDyE7QKt76LVbP+fT3rDB6mouyXtTP0UNEm0Mh65ZyoUi0mcudT6cGAxN3J0TU
# 53/oWajwvy8LpunyNDzs9wPHh6jSTEAZNUZqaVSwuKFWjuyk1T3osdz9HNj0d1pc
# VIxv76FQPfx2CWiEn2/K2yCNNWAcAgPLILCsWKAOQGPFmCLBsln1VWvPJ6tsds5v
# Iy30fnFqI2si/xK4VC0nftg62fC2h5b9W9FcrBjDTZ9ztwGpn1eqXijiuZQxggN2
# MIIDcgIBATB3MGMxCzAJBgNVBAYTAlVTMRcwFQYDVQQKEw5EaWdpQ2VydCwgSW5j
# LjE7MDkGA1UEAxMyRGlnaUNlcnQgVHJ1c3RlZCBHNCBSU0E0MDk2IFNIQTI1NiBU
# aW1lU3RhbXBpbmcgQ0ECEAuuZrxaun+Vh8b56QTjMwQwDQYJYIZIAWUDBAIBBQCg
# gdEwGgYJKoZIhvcNAQkDMQ0GCyqGSIb3DQEJEAEEMBwGCSqGSIb3DQEJBTEPFw0y
# NTA2MjcwMTA5MDhaMCsGCyqGSIb3DQEJEAIMMRwwGjAYMBYEFNvThe5i29I+e+T2
# cUhQhyTVhltFMC8GCSqGSIb3DQEJBDEiBCBKA1DJ0iWNfPO6A9licCIIILbxc01U
# j1sP4HeMfzCCBzA3BgsqhkiG9w0BCRACLzEoMCYwJDAiBCB2dp+o8mMvH0MLOiMw
# rtZWdf7Xc9sF1mW5BZOYQ4+a2zANBgkqhkiG9w0BAQEFAASCAgAtuqIrCirlic0T
# DYcrCJ5HPKyIXGsSflron2ZWzzwu9XWiE7EcLI8wDgR444Iy7jM9EBmU+QsgsWJH
# FfpPfHs44d/FNBFdaWDBlXDp/uaX8PN9nlxR3A5L1hYH51ulLJ9ENyjtN+MRdEEV
# xGsSumPV3J/swHsfj1BazKlwt1Bto2LEtVdTZefBr/ADaXxSJZFDOUv2Y13UG0rE
# hVsyCu0YC2oarJAwq82MwCTr/1hxLfd1Jfc3ZqB6PnzvsohdE9OqKxy1P2zItSp+
# z/nOS4+PyGKBr7nmC8lSwY+bo/ecfwfcdeCrx9yK2uMAu7DbQ5CkrfK0XfhxPVX/
# vm3Jju6/mdd7G1KD+1X0DxVQzuuxOgoYQ7Rusq5FMqLvKOE+y80TtPgvRsouwDHu
# PxkuRi8bPrUpIrnd5VaDNz1xwLkK4GIYQs+1/Hf/trgVCdkP7o70psGYUErjlQc2
# Q7IsD8xtuVwFHGFygI6plHgKXZVfqFJiSA7qR3DW+Cwt6+6m5p5Wb1Zjoijwvdkl
# f9Dbj9DP7DxqGYjHHfqB+EHVF2Erdetp5CJ8BhPW57gMZdudjC3wDSKgf4aovhjb
# NWFXd9fJRrcF8KyJ9BvCxI6ih0GS0BZtFF08ndx+sSIhCQ/21PjJk6UBycznMSA+
# pn9lR7InWyPJcevujhlvarYHtdNWBQ==
# SIG # End signature block
