using System;
using System.Drawing;
using System.Collections;
using System.ComponentModel;
using System.Windows.Forms;
using System.Data;
using System.IO;
using Pervasive.Data.SqlClient;

namespace DataAdapter
{
	/// <summary>
	/// Summary description for DataAdapter.
	/// </summary>
	public class DataAdapter : System.Windows.Forms.Form
	{
		private System.Windows.Forms.Label label1;
		private System.Windows.Forms.Label label2;
		private System.Windows.Forms.Label label3;
		private System.Windows.Forms.RichTextBox SelectStatement;
		private System.Windows.Forms.RichTextBox ResultSet;
		private System.Windows.Forms.Button Execute;
		private System.Windows.Forms.Button Done;
		/// <summary>
		/// Required designer variable.
		/// </summary>
		private System.ComponentModel.Container components = null;

		public DataAdapter()
		{
			//
			// Required for Windows Form Designer support
			//
			InitializeComponent();

			//
			// TODO: Add any constructor code after InitializeComponent call
			//
		}

		/// <summary>
		/// Clean up any resources being used.
		/// </summary>
		protected override void Dispose( bool disposing )
		{
			if( disposing )
			{
				if (components != null) 
				{
					components.Dispose();
				}
			}
			base.Dispose( disposing );
		}

		#region Windows Form Designer generated code
		/// <summary>
		/// Required method for Designer support - do not modify
		/// the contents of this method with the code editor.
		/// </summary>
		private void InitializeComponent()
		{
			this.label1 = new System.Windows.Forms.Label();
			this.label2 = new System.Windows.Forms.Label();
			this.label3 = new System.Windows.Forms.Label();
			this.SelectStatement = new System.Windows.Forms.RichTextBox();
			this.ResultSet = new System.Windows.Forms.RichTextBox();
			this.Execute = new System.Windows.Forms.Button();
			this.Done = new System.Windows.Forms.Button();
			this.SuspendLayout();
			// 
			// label1
			// 
			this.label1.Font = new System.Drawing.Font("Microsoft Sans Serif", 12F, (System.Drawing.FontStyle.Bold | System.Drawing.FontStyle.Underline), System.Drawing.GraphicsUnit.Point, ((System.Byte)(0)));
			this.label1.Location = new System.Drawing.Point(168, 16);
			this.label1.Name = "label1";
			this.label1.Size = new System.Drawing.Size(160, 24);
			this.label1.TabIndex = 0;
			this.label1.Text = "DataAdapter Demo";
			this.label1.Click += new System.EventHandler(this.label1_Click);
			// 
			// label2
			// 
			this.label2.Location = new System.Drawing.Point(16, 56);
			this.label2.Name = "label2";
			this.label2.Size = new System.Drawing.Size(152, 16);
			this.label2.TabIndex = 1;
			this.label2.Text = "Select Statement: (Editable)";
			this.label2.Click += new System.EventHandler(this.label2_Click);
			// 
			// label3
			// 
			this.label3.Location = new System.Drawing.Point(16, 152);
			this.label3.Name = "label3";
			this.label3.Size = new System.Drawing.Size(88, 16);
			this.label3.TabIndex = 2;
			this.label3.Text = "Result DataSet:";
			this.label3.Click += new System.EventHandler(this.label3_Click);
			// 
			// SelectStatement
			// 
			this.SelectStatement.Location = new System.Drawing.Point(16, 72);
			this.SelectStatement.Name = "SelectStatement";
			this.SelectStatement.Size = new System.Drawing.Size(488, 24);
			this.SelectStatement.TabIndex = 3;
			this.SelectStatement.Text = "SELECT ename FROM myEmp WHERE sal>50000";
			this.SelectStatement.TextChanged += new System.EventHandler(this.SelectStatement_TextChanged);
			// 
			// ResultSet
			// 
			this.ResultSet.Location = new System.Drawing.Point(16, 168);
			this.ResultSet.Name = "ResultSet";
			this.ResultSet.ReadOnly = true;
			this.ResultSet.Size = new System.Drawing.Size(488, 88);
			this.ResultSet.TabIndex = 4;
			this.ResultSet.Text = "";
			this.ResultSet.TextChanged += new System.EventHandler(this.ResultSet_TextChanged);
			// 
			// Execute
			// 
			this.Execute.Location = new System.Drawing.Point(168, 112);
			this.Execute.Name = "Execute";
			this.Execute.Size = new System.Drawing.Size(144, 23);
			this.Execute.TabIndex = 5;
			this.Execute.Text = "Execute Query";
			this.Execute.Click += new System.EventHandler(this.Execute_Click);
			// 
			// Done
			// 
			this.Done.Location = new System.Drawing.Point(192, 272);
			this.Done.Name = "Done";
			this.Done.TabIndex = 6;
			this.Done.Text = "Done";
			this.Done.Click += new System.EventHandler(this.Done_Click);
			// 
			// DataAdapter
			// 
			this.AutoScaleBaseSize = new System.Drawing.Size(5, 13);
			this.ClientSize = new System.Drawing.Size(512, 310);
			this.Controls.AddRange(new System.Windows.Forms.Control[] {
																		  this.Done,
																		  this.Execute,
																		  this.ResultSet,
																		  this.SelectStatement,
																		  this.label3,
																		  this.label2,
																		  this.label1});
			this.Name = "DataAdapter";
			this.StartPosition = System.Windows.Forms.FormStartPosition.CenterScreen;
			this.Text = "DataAdapter";
			this.Load += new System.EventHandler(this.DataAdapter_Load);
			this.ResumeLayout(false);

		}
		#endregion

		/// <summary>
		/// The main entry point for the application.
		/// </summary>
		[STAThread]
		static void Main() 
		{
			Application.Run(new DataAdapter());
		}

		private void label1_Click(object sender, System.EventArgs e)
		{
		
		}

		private void label2_Click(object sender, System.EventArgs e)
		{
		
		}

		private void label3_Click(object sender, System.EventArgs e)
		{
		
		}

		private void SelectStatement_TextChanged(object sender, System.EventArgs e)
		{
		
		}

		private void ResultSet_TextChanged(object sender, System.EventArgs e)
		{
		
		}

		private void Execute_Click(object sender, System.EventArgs e)
		{
			// Select Statement variable
			string SelectSQL = SelectStatement.Text;
			// StringWriter to append all the output
			StringWriter writer = new StringWriter();
			// Modify the connection string to match your servers
            PsqlConnection Conn = new PsqlConnection("Host=localhost;Port=1583;Database=demodata;");
			try
			{
				Conn.Open();
			}
			catch (Exception ex)
			{
				// Connection failed
				writer.WriteLine(ex.Message);
				// Dump the output on the Result window
				flush(writer);
				return;
			}
			// PsqlCommand
			PsqlCommand DBCmd = new PsqlCommand(SelectSQL, Conn);
			// PsqlDataAdapter
			PsqlDataAdapter dataAdapter = new PsqlDataAdapter();
			// Set the PsqlCommand as the SelectCommand of the DataAdapter
			dataAdapter.SelectCommand = DBCmd;
			// Define a DataSet
			DataSet ds = new DataSet("Demo");
			// Fill the DataSet with the DataAdapter result set
			try
			{
				dataAdapter.Fill(ds);
			}
			catch (Exception ex)
			{
				// Exception thrown at execution
				writer.WriteLine(ex.Message);
			}
			// Print out the result set in DataSet into the Result window
			printDataSet(ds, writer);
			// Dump the output on the Result window
			flush(writer);
			// Close the connection
			Conn.Close();
		}

		private void Done_Click(object sender, System.EventArgs e)
		{
			this.Close();
		}

		// This method call dumps the StringWriter contents on to the ResultSet window
		private void flush (StringWriter writer)
		{
			ResultSet.Clear();
			ResultSet.AppendText (writer.ToString ());
			ResultSet.Refresh();
			writer.GetStringBuilder ().Length = 0;
		}

		// This method call prints the result set in the DataSet onto the ResultSet window
		protected void printDataSet(DataSet ds, StringWriter writer)
		{
			foreach (DataTable table in ds.Tables)
			{
				bool fFirst = true;
				foreach(DataColumn col in table.Columns)
				{
					if (!fFirst) 
					{
						writer.Write(", ");
					}
					fFirst = false;
					writer.Write(col.ColumnName);
				}
				writer.WriteLine ("");
				foreach(DataRow row in table.Rows)
				{
					fFirst = true;
					foreach(DataColumn col in table.Columns)
					{
						if (!fFirst) 
						{
							writer.Write(", ");
						}
						fFirst = false;
						if ( row[col].ToString().Equals(""))
						{
							writer.Write("<null>");
						}
						else
						{
							object obj =row[col];
							string	str = obj.ToString();
							writer.Write(str);
						}
					}
					writer.WriteLine ("");
				}
			}
		}

		private void DataAdapter_Load(object sender, System.EventArgs e)
		{
		
		}
	}
}
