using IndexAnnotation.Model;
using System.Data.Entity;

namespace IndexAnnotation.Context
{
    /// <summary>
    /// Context contains two tables Customer and Orders    
    /// </summary>   
    public class PSQLDbContext : DbContext
    {        
        public PSQLDbContext() {
            // Set Initializer - "DropCreateDatabaseAlways" to drop and the create the DB always..             
            // This is to ensure we get a fresh database always when we run this application
            Database.SetInitializer(new DropCreateDatabaseAlways<PSQLDbContext>());
        }

        public virtual DbSet<Customer> Customers { get; set; }
        public virtual DbSet<Order> Orders { get; set; }
    }
    
}