﻿using SetInitializer.CreateDatabaseIfNotExist.Model;
using System.Data.Entity;

namespace SetInitializer.CreateDatabaseIfNotExist.Context
{
    /// <summary>
    /// Context contains two tables Employee and Department
    /// these two tables are related with each other in 1...n relation
    /// One Department can have multiple Employees
    /// One Employee can be related to only one Department
    /// </summary>
    public class PSQLDbContext : DbContext
    {
        public PSQLDbContext()
        {
            // Set Initializer
            // Create Database If Not Exist
            Database.SetInitializer(new CreateDatabaseIfNotExists<PSQLDbContext>());
        }

        public DbSet<Department> Departments { get; set; }
        public DbSet<Employee> Employees { get; set; }
    }
}
