namespace CodeFirstMigrations.Migrations
{
    using System;
    using System.Data.Entity.Migrations;
    
    public partial class One : DbMigration
    {
        public override void Up()
        {
            CreateTable(
                "Departments",
                c => new
                    {
                        DepartmentNo = c.Int(nullable: false, identity: true),
                        DepartmentName = c.String(maxLength: 50),
                        Location = c.String(maxLength: 50),
                    })
                .PrimaryKey(t => t.DepartmentNo);
            
            CreateTable(
                "Employees",
                c => new
                    {
                        EmpNo = c.Int(nullable: false, identity: true),
                        EmpName = c.String(maxLength: 100),
                        Designation = c.String(maxLength: 20),
                        Salary = c.Long(nullable: false),
                        DeptNo = c.Int(nullable: false),
                    })
                .PrimaryKey(t => t.EmpNo)
                .ForeignKey("Departments", t => t.DeptNo, cascadeDelete: true)
                .Index(t => t.DeptNo);
            
        }
        
        public override void Down()
        {
            DropForeignKey("Employees", "DeptNo", "Departments");
            DropIndex("Employees", new[] { "DeptNo" });
            DropTable("Employees");
            DropTable("Departments");
        }
    }
}
