﻿using System;
namespace MyApp
{
    /// <summary>
    /// This demonstrates the way to reference a Context Class which is placed in a seperate project- ability added in Entity Framework 6.1.2 - https://entityframework.codeplex.com/workitem/1752 
    /// Before running this application please ensure followings are done
    /// 1. Connection string is updated with correct connection details in app.config
    /// 2. Ensure to clean the database before running. 
    ///    Delete following two tables from the database
    ///     - "Students"
    ///     - "__MigrationHistory"    
    /// To Run the Migrations, following changes needs to be made to the Migration Commands. "-Force" as we have already enabled Migrations to the Project
    /// Enable-Migrations -ContextAssemblyName Context -Force 
    /// Please Note that the Configuration.cs generated from the execution of above command needs to be modify to use the "PervasiveDbMigrationsConfiguration" and the following line
    /// needs to be added to the Configuration() constructor
    ///  SetSqlGenerator(PervasiveConnectionInfo.InvariantName, new PervasiveEntityMigrationSqlGenerator());
    /// </summary>    
    class Program
    {
        static void Main(string[] args)
        {
            try
            {
                // Add code here to work with databases
            }
            catch (Exception ex)
            {
                ProcessExceptionMessage(ex);
            }
        }

        /// <summary>
        /// Writes Exception messages to console.
        /// If Exception contains inner exception(s) then
        /// logs all inner exception messages to console
        /// </summary>
        /// <param name="ex"></param>
        private static void ProcessExceptionMessage(Exception ex)
        {
            Console.WriteLine("Exception occurred !!!");
            while (ex != null && !String.IsNullOrWhiteSpace(ex.Message))
            {
                Console.Write("-->");
                Console.WriteLine(ex.Message);
                ex = ex.InnerException;
            }

        }
    }
}
