﻿using System;

namespace Context2
{
    /// <summary>
    /// This program demonstrates Multiple Database per Context feature, introduced in Entity Framework 6
    /// Before running this application please ensure followings are done
    /// 1. Connection string is updated with correct connection details in app.config
    /// 2. Ensure to clean the database before running. 
    ///    Delete following table from the database
    ///     - "Departments"
    /// And please follow Code First Migrations.
    /// </summary>
    class Program
    {
        static void Main(string[] args)
        {
            try
            {
                // Add code here to work with databases
            }
            catch (Exception ex)
            {
                ProcessExceptionMessage(ex);
            }
        }

        /// <summary>
        /// Writes Exception messages to console.
        /// If Exception contains inner exception(s) then
        /// logs all inner exception messages to console
        /// </summary>
        /// <param name="ex"></param>
        private static void ProcessExceptionMessage(Exception ex)
        {
            Console.WriteLine("Exception occurred !!!");
            while (ex != null && !String.IsNullOrWhiteSpace(ex.Message))
            {
                Console.Write("-->");
                Console.WriteLine(ex.Message);
                ex = ex.InnerException;
            }

        }
    }
}
