using System;
using System.Drawing;
using System.Collections;
using System.ComponentModel;
using System.Windows.Forms;
using System.Data;
using System.IO;
using Pervasive.Data.SqlClient;

namespace ScalarValue
{
	/// <summary>
	/// Summary description for ScalarValue.
	/// </summary>
	public class ScalarValue : System.Windows.Forms.Form
	{
		private System.Windows.Forms.Button DoneButton;
		private System.Windows.Forms.RichTextBox scalarfunction;
		private System.Windows.Forms.Button ExecuteButton;
		private System.Windows.Forms.RichTextBox OutputWindow;
		/// <summary>
		/// Required designer variable.
		/// </summary>
		private System.ComponentModel.Container components = null;

		public ScalarValue()
		{
			//
			// Required for Windows Form Designer support
			//
			InitializeComponent();

			//
			// TODO: Add any constructor code after InitializeComponent call
			//
		}

		/// <summary>
		/// Clean up any resources being used.
		/// </summary>
		protected override void Dispose( bool disposing )
		{
			if( disposing )
			{
				if (components != null) 
				{
					components.Dispose();
				}
			}
			base.Dispose( disposing );
		}

		#region Windows Form Designer generated code
		/// <summary>
		/// Required method for Designer support - do not modify
		/// the contents of this method with the code editor.
		/// </summary>
		private void InitializeComponent()
		{
			this.DoneButton = new System.Windows.Forms.Button();
			this.scalarfunction = new System.Windows.Forms.RichTextBox();
			this.ExecuteButton = new System.Windows.Forms.Button();
			this.OutputWindow = new System.Windows.Forms.RichTextBox();
			this.SuspendLayout();
			// 
			// DoneButton
			// 
			this.DoneButton.Location = new System.Drawing.Point(88, 208);
			this.DoneButton.Name = "DoneButton";
			this.DoneButton.TabIndex = 2;
			this.DoneButton.Text = "Done";
			this.DoneButton.Click += new System.EventHandler(this.DoneButton_Click);
			// 
			// scalarfunction
			// 
			this.scalarfunction.Location = new System.Drawing.Point(32, 48);
			this.scalarfunction.Name = "scalarfunction";
			this.scalarfunction.ReadOnly = true;
			this.scalarfunction.Size = new System.Drawing.Size(216, 24);
			this.scalarfunction.TabIndex = 0;
			this.scalarfunction.Text = "select count(sal) from myEmp where sal>50000";
			// 
			// ExecuteButton
			// 
			this.ExecuteButton.Location = new System.Drawing.Point(88, 88);
			this.ExecuteButton.Name = "ExecuteButton";
			this.ExecuteButton.TabIndex = 1;
			this.ExecuteButton.Text = "Execute";
			this.ExecuteButton.Click += new System.EventHandler(this.ExecuteButton_Click);
			// 
			// OutputWindow
			// 
			this.OutputWindow.Location = new System.Drawing.Point(32, 120);
			this.OutputWindow.Name = "OutputWindow";
			this.OutputWindow.ReadOnly = true;
			this.OutputWindow.Size = new System.Drawing.Size(216, 72);
			this.OutputWindow.TabIndex = 3;
			this.OutputWindow.Text = "";
			this.OutputWindow.TextChanged += new System.EventHandler(this.OutputWindow_TextChanged);
			// 
			// ScalarValue
			// 
			this.AutoScaleBaseSize = new System.Drawing.Size(5, 13);
			this.ClientSize = new System.Drawing.Size(264, 246);
			this.Controls.AddRange(new System.Windows.Forms.Control[] {
																		  this.OutputWindow,
																		  this.ExecuteButton,
																		  this.scalarfunction,
																		  this.DoneButton});
			this.Name = "ScalarValue";
			this.StartPosition = System.Windows.Forms.FormStartPosition.CenterScreen;
			this.Text = "ScalarValue";
			this.Load += new System.EventHandler(this.ScalarValue_Load);
			this.ResumeLayout(false);

		}
		#endregion

		/// <summary>
		/// The main entry point for the application.
		/// </summary>
		[STAThread]
		static void Main() 
		{
			Application.Run(new ScalarValue());
		}

		private void DoneButton_Click(object sender, System.EventArgs e)
		{
			this.Close();
		}

		/// <summary>
		/// Writes out all the information during 
		/// the test run onto the OutputWindow text box.
		/// </summary>
		/// <param name="writer"></param>
		private void flush (StringWriter writer)
		{
			OutputWindow.AppendText (writer.ToString ());
			OutputWindow.Refresh();
			writer.GetStringBuilder ().Length = 0;
		}

		private void ExecuteButton_Click(object sender, System.EventArgs e)
		{
			// StringWriter to write the output info
			StringWriter writer = new StringWriter();

			// Change the connection string to match your servers
            PsqlConnection Conn = new PsqlConnection("Host=localhost;Port=1583;Database=demodata;");

			try 
			{
				// Open the connection
				Conn.Open();
			}
			catch (PsqlException ex)
			{
				// Connection failed
				writer.WriteLine(ex.Message);
				flush(writer);
				return;
			}
			
			// PsqlCommand
			PsqlCommand  salCmd = new PsqlCommand("select count(sal) from myEmp where sal>50000", Conn); 

			try 
			{ 
				int count = (int)salCmd.ExecuteScalar(); 
				writer.WriteLine("Count of Salaries >$50,000 : " + Convert.ToString(count));
				flush(writer);
			} 
			catch (Exception ex)  
			{ 
				// Display any exceptions 
				writer.WriteLine(ex.Message);
				flush(writer);
			}
			// Close the connection
			Conn.Close();
		}

		private void ScalarValue_Load(object sender, System.EventArgs e)
		{
		
		}

		private void OutputWindow_TextChanged(object sender, System.EventArgs e)
		{
		
		}
	}
}
