﻿using ConfigRegistration.Model;
using System.Data.Entity;

namespace ConfigRegistration.Context
{
    /// <summary>
    /// Context contains two tables Employee and Department
    /// these two tables are related with each other in 1...n relation
    /// One Department can have multiple Employees
    /// One Employee can be related to only one Department
    /// </summary>
    public class PSQLDbContext : DbContext
    {
        public PSQLDbContext()
        {
            // Set Initializer
            // Drop and Create Database Always
            // This is to ensure we get a fresh database always we run this application
            Database.SetInitializer(new DropCreateDatabaseAlways<PSQLDbContext>());
        }

        public DbSet<Department> Departments { get; set; }
        public DbSet<Employee> Employees { get; set; }
    }
}
