﻿using System.ComponentModel.DataAnnotations;
using System.ComponentModel.DataAnnotations.Schema;

namespace IndexAnnotation.Model
{
    /// <summary>
    /// This Class demonstrates the Index Annotation to create a Unique Index.
    /// It also shows customizing a Foriegn key's index
    /// </summary>    
    public class Order
    {
        [Key]
        public int orderID { get; set; }

        // Creating a Unique Index with default name. By Default, the index will be created with IX_<propertyName> - "IX_nonKeyDefault"
        [Index(IsUnique=true)]
        public int nonKeyDefault { get; set; }
        
        public string orderDetails { get; set; }

        // Customizing the Index name that will be created on the Foreign Key
        [ForeignKey("Customer")]
        [Index("FKIndex")]
        public int custID { get; set; }
        public Customer Customer { get; set; }

    }
}
