﻿using CodeFirstMigrations.Model;
using System.Data.Entity;

namespace CodeFirstMigrations.Context
{
    /// <summary>
    /// Context contains two tables Employee and Department
    /// these two tables are related with each other in 1...n relation
    /// One Department can have multiple Employees
    /// One Employee can be related to only one Department
    /// </summary>
    public class PSQLDbContext : DbContext
    {
        public DbSet<Department> Departments { get; set; }
        public DbSet<Employee> Employees { get; set; }
    }
}
