﻿using System.ComponentModel.DataAnnotations;
using System.ComponentModel.DataAnnotations.Schema;

namespace CodeFirstMigrations.Model
{
    public class Employee
    {
        [Key]
        public int EmpNo { get; set; }
        [MaxLength(100)]
        public string EmpName { get; set; }
        [MaxLength(20)]
        public string Designation { get; set; }
        public long Salary { get; set; }
        // Foreign Key to DepartmentId in Department table
        [ForeignKey("Department")]
        public int DeptNo { get; set; }
        public Department Department { get; set; }
    }
}
