﻿using CodeFirstMigrations.Context;
using CodeFirstMigrations.Model;
using System;
using System.Linq;

namespace CodeFirstMigrations
{
    /// <summary>
    /// This program demonstrates Code First Migrations feature
    /// Before running this application please ensure followings are done
    /// 1. Connection string is updated with correct connection details in app.config
    /// 2. Ensure to clean the database before running. 
    ///    Delete following two tables from the database
    ///     - "Departments"
    ///     - "Employees"
    ///     - "__MigrationHistory"
    /// </summary>
    class Program
    {
        static void Main(string[] args)
        {
            try
            {
                // Add code here to work with databases
            }
            catch (Exception ex)
            {
                ProcessExceptionMessage(ex);
            }
        }

        /// <summary>
        /// Writes Exception messages to console.
        /// If Exception contains inner exception(s) then
        /// logs all inner exception messages to console
        /// </summary>
        /// <param name="ex"></param>
        private static void ProcessExceptionMessage(Exception ex)
        {
            Console.WriteLine("Exception occurred !!!");
            while (ex != null && !String.IsNullOrWhiteSpace(ex.Message))
            {
                Console.Write("-->");
                Console.WriteLine(ex.Message);
                ex = ex.InnerException;
            }

        }
    }
}
