﻿using System;

namespace DisableTransactions_FunctionImports
{
    /// <summary>
    /// This demonstrates the way to disable the Transactions for the Function Imports - introduced in Entity Framework 6.1.2 - https://entityframework.codeplex.com/workitem/1612
    /// Before running this application please ensure the following
    /// 1. Connection string is updated with correct connection details in "app.config"
    /// 2. Create the Following Table and Stored Procedure in the Target DB
    ///     TABLE : CREATE TABLE MyNewTable ("FirstName" CHAR(20),"LastName" CHAR(30));
    ///     STORED PROCEDURE : CREATE PROCEDURE "AddNames" (IN :FirstName char(20) , :LastName char(20)) AS BEGIN 
    ///                             INSERT INTO MyNewTable VALUES (:FirstName, :LastName); END;
    ///                             
    /// </summary>
    /// <param name="args"></param>
    class Program
    {        
        static void Main(string[] args)
        {
            try
            {
                using (var context = new FunctionImportModelContainer())
                {
                    Console.WriteLine("\n\n ************************* Sample to Demonstrate Disabling Transactions with Function Imports ************************\n ");

                    context.Database.Log = Console.Write;
                    Console.WriteLine("Calling the Function which internally calls the Procedure 'AddNames' ... ");
                    context.AddNames("John", "Smith");

                    Console.WriteLine("\nFuntion Execution Done.. ");
                    Console.WriteLine("\nNotice the Log.. The call goes in a Transaction!!");

                    Console.WriteLine("\n\nLets call the same function disabling the Transaction..\n");

                    //This property disables the Functions to be executed inside a Transaction
                    context.Configuration.EnsureTransactionsForFunctionsAndCommands = false;
                    context.AddNames("John", "Smith");
                    Console.WriteLine("\nFuntion Execution Done.. Observe that the Transactions are disabled!! ");                  
                }
            }
            catch (Exception e)
            {
                ProcessExceptionMessage(e);
            }
            finally
            {
                Console.WriteLine("Press any key to continue:");
                Console.ReadKey();
            }
            
        }

        /// <summary>
        /// Writes Exception messages to console.
        /// If Exception contains inner exception(s) then
        /// logs all inner exception messages to console
        /// </summary>
        /// <param name="ex"></param>
        private static void ProcessExceptionMessage(Exception ex)
        {
            Console.WriteLine("Exception occurred !!!");
            while (ex != null && !String.IsNullOrWhiteSpace(ex.Message))
            {
                Console.Write("-->");
                Console.WriteLine(ex.Message);
                ex = ex.InnerException;
            }

        }
    }
}
