//
//  AdFitAdapter.m
//  AdPopcornSSP
//
//  Created by mick on 2017. 8. 2..
//  Copyright (c) 2017년 igaworks All rights reserved.
//

// compatible with AdFit v3.12.5
#import "AdFitAdapter.h"

static inline NSString *SSPErrorString(SSPErrorCode code)
{
    switch (code)
    {
        case AdPopcornSSPException:
            return @"Exception";
        case AdPopcornSSPInvalidParameter:
            return @"Invalid Parameter";
        case AdPopcornSSPUnknownServerError:
            return @"Unknown Server Error";
        case AdPopcornSSPInvalidMediaKey:
            return @"Invalid Media key";
        case AdPopcornSSPInvalidPlacementId:
            return @"Invalid Placement Id";
        case AdPopcornSSPInvalidNativeAssetsConfig:
            return @"Invalid native assets config";
        case AdPopcornSSPNativePlacementDoesNotInitialized:
            return @"Native Placement Does Not Initialized";
        case AdPopcornSSPServerTimeout:
            return @"Server Timeout";
        case AdPopcornSSPLoadAdFailed:
            return @"Load Ad Failed";
        case AdPopcornSSPNoAd:
            return @"No Ad";
        case AdPopcornSSPNoInterstitialLoaded:
            return @"No Interstitial Loaded";
        case AdPopcornSSPNoRewardVideoAdLoaded:
            return @"No Reward video ad Loaded";
        case AdPopcornSSPMediationAdapterNotInitialized:
            return @"Mediation Adapter Not Initialized";
        default: {
            return @"Success";
        }
    }
}

@interface AdFitAdapter () <AdFitBannerAdViewDelegate, AdFitNativeAdDelegate, AdFitNativeAdLoaderDelegate>
{
    APAdFitNativeAdRenderer *adfitNativeAdRenderer;
}

- (void)addAlignCenterConstraint;
@end

@implementation AdFitAdapter

@synthesize delegate = _delegate;
@synthesize integrationKey = _integrationKey;
@synthesize viewController = _viewController;
@synthesize bannerView = _bannerView;
@synthesize adpopcornSSPNativeAd = _adpopcornSSPNativeAd;

- (instancetype)init
{
    self = [super init];
    if (self)
    {
        
    }
    
    return self;
}

- (void)setViewController:(UIViewController *)viewController origin:(CGPoint)origin size:(CGSize)size bannerView:(AdPopcornSSPBannerView *)bannerView
{
    _viewController = viewController;
    _origin = origin;
    _size = size;
    _bannerView = bannerView;
    _adType = SSPAdBannerType;
}

- (void)setViewController:(UIViewController *)viewController
{
}

- (void)setRewardVideoViewController:(UIViewController *)viewController
{
}

- (void)setNativeAdViewController:(UIViewController *)viewController nativeAdRenderer:(id)nativeAdRenderer rootNativeAdView:(AdPopcornSSPNativeAd *)adpopcornSSPNativeAd
{
    _viewController = viewController;
    _adType = SSPNativeAdType;
    if([nativeAdRenderer isKindOfClass:[APAdFitNativeAdRenderer class]])
        adfitNativeAdRenderer = nativeAdRenderer;
    _adpopcornSSPNativeAd = adpopcornSSPNativeAd;
}

- (BOOL)isSupportInterstitialAd
{
    return NO;
}

- (BOOL)isSupportRewardVideoAd
{
    return NO;
}

- (BOOL)isSupportNativeAd
{
    return YES;
}

- (void)loadAd
{
    if (_adType == SSPAdBannerType)
    {
        if (_integrationKey != nil)
        {
            NSString *clientId = [_integrationKey valueForKey:[[_integrationKey allKeys] firstObject]];

            if(_adFitBannerAdView != nil)
            {
                [_adFitBannerAdView removeFromSuperview];
                _adFitBannerAdView.delegate = nil;
                _adFitBannerAdView = nil;
            }
            
            if(_size.width == 320.0f && _size.height == 100.0f)
            {
                _adFitBannerAdView = [[AdFitBannerAdView alloc] initWithClientId:clientId adUnitSize:@"320x100"];
                _adFitBannerAdView.frame = CGRectMake(0.f, 0.f, _bannerView.bounds.size.width, 100.f);
            }
            else if(_size.width == 300.0f && _size.height == 250.0f)
            {
                _adFitBannerAdView = [[AdFitBannerAdView alloc] initWithClientId:clientId adUnitSize:@"300x250"];
                _adFitBannerAdView.frame = CGRectMake(0.f, 0.f, _bannerView.bounds.size.width, 250.f);
            }
            else
            {
                _adFitBannerAdView = [[AdFitBannerAdView alloc] initWithClientId:clientId adUnitSize:@"320x50"];
                _adFitBannerAdView.frame = CGRectMake(0.f, 0.f, _bannerView.bounds.size.width, 50.f);
            }

            [_bannerView addSubview:_adFitBannerAdView];
            [self addAlignCenterConstraint];
            
            _adFitBannerAdView.rootViewController = _viewController;
            _adFitBannerAdView.delegate = self;
            
            [_adFitBannerAdView loadAd];
        }
        else
        {
          if ([_delegate respondsToSelector:@selector(AdPopcornSSPAdapterBannerViewLoadFailError:adapter:)])
          {
            [_delegate AdPopcornSSPAdapterBannerViewLoadFailError:[AdPopcornSSPError errorWithDomain:kAdPopcornSSPErrorDomain code:AdPopcornSSPMediationInvalidIntegrationKey userInfo:@{NSLocalizedDescriptionKey: SSPErrorString(AdPopcornSSPMediationInvalidIntegrationKey)}] adapter:self];
          }
          
          [self closeAd];
        }
    }
    else if(_adType == SSPNativeAdType)
    {
        if (_integrationKey != nil)
        {
            NSString *clientId = [_integrationKey valueForKey:[[_integrationKey allKeys] firstObject]];
        
            [_adpopcornSSPNativeAd addSubview:adfitNativeAdRenderer.adfitBizBoardTemplate];
            
            CGFloat width = _adpopcornSSPNativeAd.frame.size.width;
            CGFloat height = width / (1029 / 222);
            
            adfitNativeAdRenderer.adfitBizBoardTemplate.frame = CGRectMake(0, 0, width, height);
            _adFitNativeAdLoader = [[AdFitNativeAdLoader alloc] initWithClientId:clientId count:1];
            _adFitNativeAdLoader.delegate = self;
            
            [_adFitNativeAdLoader loadAd];
        }
        else
        {
            if ([_delegate respondsToSelector:@selector(AdPopcornSSPAdapterNativeAdLoadFailError:adapter:)])
            {
              [_delegate AdPopcornSSPAdapterNativeAdLoadFailError:[AdPopcornSSPError errorWithDomain:kAdPopcornSSPErrorDomain code:AdPopcornSSPMediationInvalidIntegrationKey userInfo:@{NSLocalizedDescriptionKey: SSPErrorString(AdPopcornSSPMediationInvalidIntegrationKey)}] adapter:self];
            }
            
            [self closeAd];
        }
    }
}

- (void)addAlignCenterConstraint
{
    // add constraints
    [_adFitBannerAdView setTranslatesAutoresizingMaskIntoConstraints:NO];
    UIView *superview = _bannerView;
    [superview addConstraint: [NSLayoutConstraint constraintWithItem:_adFitBannerAdView attribute:NSLayoutAttributeCenterX relatedBy:NSLayoutRelationEqual toItem:superview attribute:NSLayoutAttributeCenterX multiplier:1 constant:0]];
    
    [superview addConstraint: [NSLayoutConstraint constraintWithItem:_adFitBannerAdView attribute:NSLayoutAttributeCenterY relatedBy:NSLayoutRelationEqual toItem:superview attribute:NSLayoutAttributeCenterY multiplier:1 constant:0]];
    
    [superview addConstraint:[NSLayoutConstraint constraintWithItem:_adFitBannerAdView attribute:NSLayoutAttributeHeight relatedBy:NSLayoutRelationEqual toItem:superview attribute:NSLayoutAttributeHeight multiplier:0.0 constant:_size.height]];
    
    [superview addConstraint:[NSLayoutConstraint constraintWithItem:_adFitBannerAdView attribute:NSLayoutAttributeWidth relatedBy:NSLayoutRelationEqual toItem:superview attribute:NSLayoutAttributeWidth multiplier:0.0 constant:_size.width]];
}


- (void)showAd
{
    
}

- (void)closeAd
{
    NSLog(@"AdFitAdapter : closeAd");
    
    if (_adType == SSPAdBannerType)
    {
        [_adFitBannerAdView removeFromSuperview];
        _adFitBannerAdView.delegate = nil;
        _adFitBannerAdView = nil;
    }
    else if(_adType == SSPNativeAdType)
    {
        if(_adFitNativeAdLoader != nil)
        {
            _adFitNativeAdLoader.delegate = nil;
            _adFitNativeAdLoader = nil;
        }
    }
}

- (void)loadRequest
{
    // Not used any more
}

- (void)bindAdView
{
    _adFitNativeAd.infoIconTopConstant = adfitNativeAdRenderer.bizBoardInfoIconTopConstant;
    _adFitNativeAd.infoIconRightConstant = adfitNativeAdRenderer.bizBoardInfoIconRightConstant;
    _adFitNativeAd.infoIconBottomConstant = adfitNativeAdRenderer.bizBoardInfoIconBottomConstant;
    _adFitNativeAd.infoIconLeftConstant = adfitNativeAdRenderer.bizBoardInfoIconLeftConstant;
    [_adFitNativeAd bind:adfitNativeAdRenderer.adfitBizBoardTemplate];
    _adFitNativeAd.delegate = self;
    adfitNativeAdRenderer.adfitBizBoardTemplate.autoresizingMask = UIViewAutoresizingFlexibleWidth;
    
}

#pragma mark - AdFitBannerAdViewDelegate
- (void)adViewDidReceiveAd:(AdFitBannerAdView *)bannerAdView {
    NSLog(@"AdFitAdapter didReceiveAd");
    if ([_delegate respondsToSelector:@selector(AdPopcornSSPAdapterBannerViewLoadSuccess:)])
    {
        [_delegate AdPopcornSSPAdapterBannerViewLoadSuccess:self];
    }
}

- (void)adViewDidFailToReceiveAd:(AdFitBannerAdView *)bannerAdView error:(NSError *)error {
    NSLog(@"AdFitAdapter didFailToReceiveAd - error = %@", [error localizedDescription]);
    if ([_delegate respondsToSelector:@selector(AdPopcornSSPAdapterBannerViewLoadFailError:adapter:)])
    {
        [_delegate AdPopcornSSPAdapterBannerViewLoadFailError:error adapter:self];
    }
    
    [self closeAd];
}

- (void)adViewDidClickAd:(AdFitBannerAdView *)bannerAdView {
    NSLog(@"AdFitAdapter didClickAd");
    if ([_delegate respondsToSelector:@selector(AdPopcornSSPAdapterBannerViewClicked:)])
    {
        [_delegate AdPopcornSSPAdapterBannerViewClicked:self];
    }
}

#pragma mark AdFitNativeAdLoaderDelegate
- (void)nativeAdLoaderDidReceiveAd:(AdFitNativeAd * _Nonnull)nativeAd
{
    NSLog(@"AdFitAdapter nativeAdLoaderDidReceiveAd");
    _adFitNativeAd = nativeAd;
    _adpopcornSSPNativeAd.hidden = NO;
    [self bindAdView];
    
    if ([_delegate respondsToSelector:@selector(AdPopcornSSPAdapterNativeAdLoadSuccess:)])
    {
        [_delegate AdPopcornSSPAdapterNativeAdLoadSuccess:self];
    }
}
/// 네이티브 광고 로드에 실패한 경우 호출됩니다.
- (void)nativeAdLoaderDidFailToReceiveAd:(AdFitNativeAdLoader * _Nonnull)nativeAdLoader error:(NSError * _Nonnull)error
{
    NSLog(@"AdFitAdapter nativeAdLoaderDidFailToReceiveAd : %@", error);
    if ([_delegate respondsToSelector:@selector(AdPopcornSSPAdapterNativeAdLoadFailError:adapter:)])
    {
        [_delegate AdPopcornSSPAdapterNativeAdLoadFailError:error adapter:self];
    }
}

#pragma mark AdFitNativeAdDelegate
- (void)nativeAdDidClickAd:(AdFitNativeAd * _Nonnull)nativeAd
{
    NSLog(@"AdFitAdapter nativeAdDidClickAd");
    if ([_delegate respondsToSelector:@selector(AdPopcornSSPAdapterNativeAdClicked:)])
    {
        [_delegate AdPopcornSSPAdapterNativeAdClicked:self];
    }
}
@end

@implementation APAdFitNativeAdRenderer
{
}
@end
