//
//  MezzoAdapter.m
//  AdPopcornSSP
//
//  Created by mick on 2017. 9. 6..
//  Copyright (c) 2017년 igaworks All rights reserved.

// compatible with Mezzo v2 110
#import "MezzoAdapter.h"

static inline NSString *SSPErrorString(SSPErrorCode code)
{
    switch (code)
    {
        case AdPopcornSSPException:
            return @"Exception";
        case AdPopcornSSPInvalidParameter:
            return @"Invalid Parameter";
        case AdPopcornSSPUnknownServerError:
            return @"Unknown Server Error";
        case AdPopcornSSPInvalidMediaKey:
            return @"Invalid Media key";
        case AdPopcornSSPInvalidPlacementId:
            return @"Invalid Placement Id";
        case AdPopcornSSPInvalidNativeAssetsConfig:
            return @"Invalid native assets config";
        case AdPopcornSSPNativePlacementDoesNotInitialized:
            return @"Native Placement Does Not Initialized";
        case AdPopcornSSPServerTimeout:
            return @"Server Timeout";
        case AdPopcornSSPLoadAdFailed:
            return @"Load Ad Failed";
        case AdPopcornSSPNoAd:
            return @"No Ad";
        case AdPopcornSSPNoInterstitialLoaded:
            return @"No Interstitial Loaded";
        case AdPopcornSSPNoRewardVideoAdLoaded:
            return @"No Reward video ad Loaded";
        case AdPopcornSSPMediationAdapterNotInitialized:
            return @"Mediation Adapter Not Initialized";
        default: {
            return @"Success";
        }
    }
}


@interface MezzoAdapter () <ManBannerDelegate>
{
    NSString *appID, *appName, *storeURL;
}
- (void)addAlignCenterConstraint;
@end

@implementation MezzoAdapter

@synthesize delegate = _delegate;
@synthesize integrationKey = _integrationKey;
@synthesize viewController = _viewController;
@synthesize bannerView = _bannerView;

- (instancetype)init
{
    self = [super init];
    if (self)
    {
        appID = @"ApplicationID";
        appName = @"ApplicationName";
        storeURL = @"AppStoreURL";
    }
    
    return self;
}


- (void)setViewController:(UIViewController *)viewController origin:(CGPoint)origin size:(CGSize)size bannerView:(AdPopcornSSPBannerView *)bannerView
{
    _viewController = viewController;
    _origin = origin;
    _size = size;
    _bannerView = bannerView;
    _adType = SSPAdBannerType;
}

- (void)setViewController:(UIViewController *)viewController
{
    _viewController = viewController;
    _adType = SSPAdInterstitialType;
}

- (BOOL)isSupportInterstitialAd
{
    return NO;
}

- (BOOL)isSupportRewardVideoAd
{
    return NO;
}

- (void)loadAd
{
    if (_adType == SSPAdBannerType)
    {
        if (_integrationKey != nil)
        {
            NSString *publisherCode = [_integrationKey valueForKey:@"PublisherCode"];
            NSString *mediaCode = [_integrationKey valueForKey:@"MediaCode"];
            NSString *sectionCode = [_integrationKey valueForKey:@"SectionCode"];
            
            NSLog(@"SSPAdBannerType PublisherCode : %@", publisherCode);
            NSLog(@"SSPAdBannerType MediaCode : %@", mediaCode);
            NSLog(@"SSPAdBannerType SectionCode : %@", sectionCode);
            if((_size.width == 300.0f && _size.height == 250.0f))
            {
                NSLog(@"%@ : MezzoMedia can not load 300x250", self);
                if ([_delegate respondsToSelector:@selector(AdPopcornSSPAdapterBannerViewLoadFailError:adapter:)])
                {
                    [_delegate AdPopcornSSPAdapterBannerViewLoadFailError:[NSError errorWithDomain:kAdPopcornSSPErrorDomain code:AdPopcornSSPLoadAdFailed userInfo:@{NSLocalizedDescriptionKey: SSPErrorString(AdPopcornSSPLoadAdFailed)}] adapter:self];
                }
                
                [self closeAd];
                return;
            }

            if(_adBannerView == nil)
            {
                _adBannerView = [[ManBanner alloc] initWithFrame:CGRectMake(0, 0, _bannerView.bounds.size.width, _size.height)];
            }
            else
            {
                [_adBannerView removeFromSuperview];
            }
            
            [_adBannerView infoSDK];
            
            // app_id, app_name, store_url 설정
            [_adBannerView appID:appID appName:appName storeURL:storeURL];

            _adBannerView.bannerDelegate = self;
            
            // 발급받은 publisher id와 media id, section id 설정
            [_adBannerView publisherID:publisherCode mediaID:mediaCode sectionID:sectionCode x:0 y:0 width:_bannerView.bounds.size.width height:_size.height type:@"0"]; // type 0 : banner
            
            // 광고뷰의 가로 사이즈를 뷰에 자동으로 맞춘다.
            _adBannerView.autoresizingMask = UIViewAutoresizingFlexibleWidth;
            
            // add banner view
            [_bannerView addSubview:_adBannerView];
            
            [self addAlignCenterConstraint];
            
            [_adBannerView startBanner];
        }
        else
        {
          if ([_delegate respondsToSelector:@selector(AdPopcornSSPAdapterBannerViewLoadFailError:adapter:)])
          {
            [_delegate AdPopcornSSPAdapterBannerViewLoadFailError:[AdPopcornSSPError errorWithDomain:kAdPopcornSSPErrorDomain code:AdPopcornSSPMediationInvalidIntegrationKey userInfo:@{NSLocalizedDescriptionKey: SSPErrorString(AdPopcornSSPMediationInvalidIntegrationKey)}] adapter:self];
          }
          
          [self closeAd];
        }
    }
}

- (void)showAd
{
    NSLog(@"%@ : showAd", self);
}

- (void)closeAd
{
    NSLog(@"%@ : closeAd", self);
    if (_adType == SSPAdBannerType)
    {
        _adBannerView.bannerDelegate = nil;
    }
}

- (void)addAlignCenterConstraint
{
    [_adBannerView setTranslatesAutoresizingMaskIntoConstraints:NO];
    
    UIView *superview = _bannerView;
    [superview addConstraint:[NSLayoutConstraint constraintWithItem:_adBannerView attribute:NSLayoutAttributeCenterX relatedBy:NSLayoutRelationEqual toItem:superview attribute:NSLayoutAttributeCenterX multiplier:1 constant:0]];
    
    [superview addConstraint:[NSLayoutConstraint constraintWithItem:_adBannerView attribute:NSLayoutAttributeCenterY relatedBy:NSLayoutRelationEqual toItem:superview attribute:NSLayoutAttributeCenterY multiplier:1 constant:0]];
    
    [superview addConstraint:[NSLayoutConstraint constraintWithItem:_adBannerView attribute:NSLayoutAttributeHeight relatedBy:NSLayoutRelationEqual toItem:superview attribute:NSLayoutAttributeHeight multiplier:0.0 constant:_size.height]];
    
    [superview addConstraint:[NSLayoutConstraint constraintWithItem:_adBannerView attribute:NSLayoutAttributeWidth relatedBy:NSLayoutRelationEqual toItem:superview attribute:NSLayoutAttributeWidth multiplier:0.0 constant:_size.width]];
}

#pragma mark ManBannerDelegate
- (void)didFailReceiveAd:(ManBanner*)adBanner errorType:(NSInteger)errorType
{
    NSLog(@"MezzoAdapter didFailReceiveAd errorType : %ld", errorType);
    switch (errorType) {
      case NewManAdSuccess:
            NSLog(@"MezzoAdapter didFailReceiveAd : NewManAdSuccess");
            if ([_delegate respondsToSelector:@selector(AdPopcornSSPAdapterBannerViewLoadSuccess:)])
            {
                [_delegate AdPopcornSSPAdapterBannerViewLoadSuccess:self];
            }
            break;

      case NewManAdClick:
            NSLog(@"MezzoAdapter didFailReceiveAd : NewManAdClick");
            if ([_delegate respondsToSelector:@selector(AdPopcornSSPAdapterBannerViewClicked:)])
            {
                [_delegate AdPopcornSSPAdapterBannerViewClicked:self];
            }
            break;
        case NewManAdError:
        case NewManAdNetworkError:
        case NewManAdNotExistError:
        case NewManAdIDError:
        case NewManAdTimeoutError:
        case NewManAdAppStoreUrlError:
            if ([_delegate respondsToSelector:@selector(AdPopcornSSPAdapterBannerViewLoadFailError:adapter:)])
            {
                [_delegate AdPopcornSSPAdapterBannerViewLoadFailError:[NSError errorWithDomain:kAdPopcornSSPErrorDomain code:AdPopcornSSPLoadAdFailed userInfo:@{NSLocalizedDescriptionKey: SSPErrorString(AdPopcornSSPLoadAdFailed)}] adapter:self];
            }
            break;
    }
}


- (void)didBlockReloadAd:(ManBanner *)adBanner {
    NSLog(@"MezzoAdapter didBlockReloadAd");
}
@end
