//
//  MopubAdapter.m
//  AdPopcornSSP
//
//  Created by mick on 2017. 8. 2..
//  Copyright (c) 2017년 igaworks All rights reserved.
//

// compatible with Mopub v5.14.1
#import "MopubAdapter.h"

static inline NSString *SSPErrorString(SSPErrorCode code)
{
    switch (code)
    {
        case AdPopcornSSPException:
            return @"Exception";
        case AdPopcornSSPInvalidParameter:
            return @"Invalid Parameter";
        case AdPopcornSSPUnknownServerError:
            return @"Unknown Server Error";
        case AdPopcornSSPInvalidMediaKey:
            return @"Invalid Media key";
        case AdPopcornSSPInvalidPlacementId:
            return @"Invalid Placement Id";
        case AdPopcornSSPInvalidNativeAssetsConfig:
            return @"Invalid native assets config";
        case AdPopcornSSPNativePlacementDoesNotInitialized:
            return @"Native Placement Does Not Initialized";
        case AdPopcornSSPServerTimeout:
            return @"Server Timeout";
        case AdPopcornSSPLoadAdFailed:
            return @"Load Ad Failed";
        case AdPopcornSSPNoAd:
            return @"No Ad";
        case AdPopcornSSPNoInterstitialLoaded:
            return @"No Interstitial Loaded";
        case AdPopcornSSPNoRewardVideoAdLoaded:
            return @"No Reward video ad Loaded";
        case AdPopcornSSPMediationAdapterNotInitialized:
            return @"Mediation Adapter Not Initialized";
        default: {
            return @"Success";
        }
    }
}

@interface MopubAdapter () <MPAdViewDelegate, MPInterstitialAdControllerDelegate, MPNativeAdDelegate>
{
    APMoPubNativeAdRenderer *mopubNativeAdRenderer;
}

- (void)addAlignCenterConstraint;

@end

@implementation MopubAdapter

@synthesize delegate = _delegate;
@synthesize integrationKey = _integrationKey;
@synthesize viewController = _viewController;
@synthesize bannerView = _bannerView;
@synthesize adpopcornSSPNativeAd = _adpopcornSSPNativeAd;
@synthesize adBannerView = _adBannerView;

- (instancetype)init
{
    self = [super init];
    if (self)
    {
        
    }
    
    return self;
}


- (void)setViewController:(UIViewController *)viewController origin:(CGPoint)origin size:(CGSize)size bannerView:(AdPopcornSSPBannerView *)bannerView
{
    _viewController = viewController;
    _origin = origin;
    _size = size;
    _bannerView = bannerView;
    _adType = SSPAdBannerType;
}

- (void)setViewController:(UIViewController *)viewController
{
    _viewController = viewController;
    _adType = SSPAdInterstitialType;
}

- (void)setNativeAdViewController:(UIViewController *)viewController nativeAdRenderer:(id)nativeAdRenderer rootNativeAdView:(AdPopcornSSPNativeAd *)adpopcornSSPNativeAd
{
    _viewController = viewController;
    _adType = SSPNativeAdType;
    if([nativeAdRenderer isKindOfClass:[APMoPubNativeAdRenderer class]])
        mopubNativeAdRenderer = nativeAdRenderer;
    _adpopcornSSPNativeAd = adpopcornSSPNativeAd;
}

- (BOOL)isSupportInterstitialAd
{
    return YES;
}

- (BOOL)isSupportRewardVideoAd
{
    return NO;
}

- (BOOL)isSupportNativeAd
{
    return YES;
}

- (void)loadAd
{
    if (_adType == SSPAdBannerType)
    {
        if (_integrationKey != nil)
        {
            NSString *adUnitID = [_integrationKey valueForKey:[[_integrationKey allKeys] firstObject]];
            
            if(_size.width == 320.0f && _size.height == 100.0f)
            {
                NSLog(@"%@ : Mopub can not load 320x100", self);
                if ([_delegate respondsToSelector:@selector(AdPopcornSSPAdapterBannerViewLoadFailError:adapter:)])
                {
                    [_delegate AdPopcornSSPAdapterBannerViewLoadFailError:[NSError errorWithDomain:kAdPopcornSSPErrorDomain code:AdPopcornSSPLoadAdFailed userInfo:@{NSLocalizedDescriptionKey: SSPErrorString(AdPopcornSSPLoadAdFailed)}] adapter:self];
                }
                
                [self closeAd];
                return;
            }
            
            if(_adBannerView == nil)
            {
                _adBannerView = [[MPAdView alloc] initWithAdUnitId:adUnitID];
            }
            else
            {
                [_adBannerView removeFromSuperview];
            }
            _adBannerView.frame = CGRectMake(0, 0, kMPPresetMaxAdSizeMatchFrame.width, kMPPresetMaxAdSizeMatchFrame.height);
           
            // add banner view
            [_bannerView addSubview:_adBannerView];
            [self addAlignCenterConstraint];
            
            _adBannerView.delegate = self;
            
            // load request
            if(_size.width == 300.0f && _size.height == 250.0f)
            {
                [_adBannerView loadAdWithMaxAdSize:kMPPresetMaxAdSize250Height];
            }
            else
            {
                [_adBannerView loadAdWithMaxAdSize:kMPPresetMaxAdSize50Height];
            }
        }
        else
        {
          if ([_delegate respondsToSelector:@selector(AdPopcornSSPAdapterBannerViewLoadFailError:adapter:)])
          {
              [_delegate AdPopcornSSPAdapterBannerViewLoadFailError:[AdPopcornSSPError errorWithDomain:kAdPopcornSSPErrorDomain code:AdPopcornSSPMediationInvalidIntegrationKey userInfo:@{NSLocalizedDescriptionKey: SSPErrorString(AdPopcornSSPMediationInvalidIntegrationKey)}] adapter:self];
          }
          
          [self closeAd];
        }
    }
    else if (_adType == SSPAdInterstitialType)
    {
        if (_integrationKey != nil)
        {
            NSString *adUnitID = [_integrationKey valueForKey:[[_integrationKey allKeys] firstObject]];
            
            _interstitial = [MPInterstitialAdController
                             interstitialAdControllerForAdUnitId:adUnitID];
            _interstitial.delegate = self;
            [_interstitial loadAd];
        }
        else
        {
            if ([_delegate respondsToSelector:@selector(AdPopcornSSPAdapterInterstitialAdLoadFailError:adapter:)])
            {
                [_delegate AdPopcornSSPAdapterInterstitialAdLoadFailError:[NSError errorWithDomain:kAdPopcornSSPErrorDomain code:AdPopcornSSPMediationInvalidIntegrationKey userInfo:@{NSLocalizedDescriptionKey: SSPErrorString(AdPopcornSSPMediationInvalidIntegrationKey)}] adapter:self];
            }
            
            [self closeAd];
        }
    }
    else if(_adType == SSPNativeAdType)
    {
        if (_integrationKey != nil)
        {
            NSString *adUnitID = [_integrationKey valueForKey:[[_integrationKey allKeys] firstObject]];
            
            // Create and configure a renderer configuration for native ads.
            MPStaticNativeAdRendererSettings *settings = [[MPStaticNativeAdRendererSettings alloc] init];
            settings.renderingViewClass = mopubNativeAdRenderer.renderingViewClass;
            
            MPNativeAdRendererConfiguration *config = [MPStaticNativeAdRenderer rendererConfigurationWithRendererSettings:settings];

            NSMutableArray * configurations = [NSMutableArray arrayWithObject:config];
            
            MPNativeAdRequest *adRequest = [MPNativeAdRequest requestWithAdUnitIdentifier:adUnitID rendererConfigurations:configurations];
            
            [adRequest startWithCompletionHandler:^(MPNativeAdRequest *request, MPNativeAd *response, NSError *error) {
                if (error) {
                    NSLog(@"MopubAdapter native ad load fail");
                    if ([_delegate respondsToSelector:@selector(AdPopcornSSPAdapterNativeAdLoadFailError:adapter:)])
                    {
                        [_delegate AdPopcornSSPAdapterNativeAdLoadFailError:error adapter:self];
                    }
                } else {
                    _nativeAd = response;
                    _nativeAd.delegate = self;
                    
                    [self showNativeAd];
                }
            }];
        }
        else
        {
            if ([_delegate respondsToSelector:@selector(AdPopcornSSPAdapterNativeAdLoadFailError:adapter:)])
            {
                [_delegate AdPopcornSSPAdapterNativeAdLoadFailError:[NSError errorWithDomain:kAdPopcornSSPErrorDomain code:AdPopcornSSPMediationInvalidIntegrationKey userInfo:@{NSLocalizedDescriptionKey: SSPErrorString(AdPopcornSSPMediationInvalidIntegrationKey)}] adapter:self];
            }
            
            [self closeAd];
        }
    }
}

- (void)closeAd
{
    NSLog(@"%@ : closeAd", self);
    if (_adType == SSPAdBannerType)
    {
        if(_adBannerView != nil)
        {
            _adBannerView.delegate = nil;
        }
    }
    else if (_adType == SSPAdInterstitialType)
    {
        _interstitial.delegate = nil;
        _interstitial = nil;
    }
}

- (void)showAd
{
    NSLog(@"%@ : showAd", self);
    if (_adType == SSPAdInterstitialType)
    {
        if (_interstitial.ready)
            [_interstitial showFromViewController:_viewController];
        else
        {
            if ([_delegate respondsToSelector:@selector(AdPopcornSSPAdapterInterstitialAdShowFailError:adapter:)])
            {
                [_delegate AdPopcornSSPAdapterInterstitialAdShowFailError:[NSError errorWithDomain:kAdPopcornSSPErrorDomain code:AdPopcornSSPNoInterstitialLoaded userInfo:@{NSLocalizedDescriptionKey: SSPErrorString(AdPopcornSSPNoInterstitialLoaded)}] adapter:self];
            }
        }
    }
}

- (void)addAlignCenterConstraint
{
    // add constraints
    [_adBannerView setTranslatesAutoresizingMaskIntoConstraints:NO];
    UIView *superview = _bannerView;
    [superview addConstraint:[NSLayoutConstraint constraintWithItem:_adBannerView attribute:NSLayoutAttributeCenterX relatedBy:NSLayoutRelationEqual toItem:superview attribute:NSLayoutAttributeCenterX multiplier:1 constant:0]];
    
    [superview addConstraint:[NSLayoutConstraint constraintWithItem:_adBannerView attribute:NSLayoutAttributeCenterY relatedBy:NSLayoutRelationEqual toItem:superview attribute:NSLayoutAttributeCenterY multiplier:1 constant:0]];
    
    [superview addConstraint:[NSLayoutConstraint constraintWithItem:_adBannerView attribute:NSLayoutAttributeHeight relatedBy:NSLayoutRelationEqual toItem:superview attribute:NSLayoutAttributeHeight multiplier:0.0 constant:_size.height]];
    
    [superview addConstraint:[NSLayoutConstraint constraintWithItem:_adBannerView attribute:NSLayoutAttributeWidth relatedBy:NSLayoutRelationEqual toItem:superview attribute:NSLayoutAttributeWidth multiplier:0.0 constant:_size.width]];
}

#pragma mark - MPAdViewDelegate
- (UIViewController *)viewControllerForPresentingModalView {
    NSLog(@"viewControllerForPresentingModalView");
    return _viewController;
}

- (void)adViewDidLoadAd:(MPAdView *)view
{
    NSLog(@"adViewDidLoadAd : %@", view);
    
    if ([_delegate respondsToSelector:@selector(AdPopcornSSPAdapterBannerViewLoadSuccess:)])
    {
        [_delegate AdPopcornSSPAdapterBannerViewLoadSuccess:self];
    }
}   

- (void)adViewDidFailToLoadAd:(MPAdView *)view
{
    NSLog(@"adViewDidFailToLoadAd : %@", view);
    
    if ([_delegate respondsToSelector:@selector(AdPopcornSSPAdapterBannerViewLoadFailError:adapter:)])
    {
        [_delegate AdPopcornSSPAdapterBannerViewLoadFailError:nil adapter:self];
    }
}

- (void)willPresentModalViewForAd:(MPAdView *)view
{
    NSLog(@"willPresentModalViewForAd : %@", view);
}

- (void)didDismissModalViewForAd:(MPAdView *)view
{
    NSLog(@"didDismissModalViewForAd : %@", view);
}

- (void)willLeaveApplicationFromAd:(MPAdView *)view
{
    NSLog(@"willLeaveApplicationFromAd : %@", view);
    
    if ([_delegate respondsToSelector:@selector(AdPopcornSSPAdapterBannerViewClicked:)])
    {
        [_delegate AdPopcornSSPAdapterBannerViewClicked:self];
    }
}

#pragma mark - MPInterstitialAdControllerDelegate
- (void)interstitialDidLoadAd:(MPInterstitialAdController *)interstitial
{
    NSLog(@"interstitialDidLoadAd : %@", interstitial);
    if ([_delegate respondsToSelector:@selector(AdPopcornSSPAdapterInterstitialAdLoadSuccess:)])
    {
        [_delegate AdPopcornSSPAdapterInterstitialAdLoadSuccess:self];
    }
}

- (void)interstitialDidFailToLoadAd:(MPInterstitialAdController *)interstitial
{
    NSLog(@"interstitialDidFailToLoadAd : %@", interstitial);
    [self closeAd];
    
    if ([_delegate respondsToSelector:@selector(AdPopcornSSPAdapterInterstitialAdLoadFailError:adapter:)])
    {
        [_delegate AdPopcornSSPAdapterInterstitialAdLoadFailError:nil adapter:self];
    }
}

- (void)interstitialWillAppear:(MPInterstitialAdController *)interstitial
{
    NSLog(@"interstitialWillAppear : %@", interstitial);
}

- (void)interstitialDidAppear:(MPInterstitialAdController *)interstitial
{
    NSLog(@"interstitialDidAppear : %@", interstitial);
    if ([_delegate respondsToSelector:@selector(AdPopcornSSPAdapterInterstitialAdShowSuccess:)])
    {
        [_delegate AdPopcornSSPAdapterInterstitialAdShowSuccess:self];
    }
}

- (void)interstitialWillDisappear:(MPInterstitialAdController *)interstitial
{
    NSLog(@"interstitialWillDisappear : %@", interstitial);
}

- (void)interstitialDidDisappear:(MPInterstitialAdController *)interstitial
{
    NSLog(@"interstitialDidDisappear : %@", interstitial);
    if ([_delegate respondsToSelector:@selector(AdPopcornSSPAdapterInterstitialAdClosed:)])
    {
        [_delegate AdPopcornSSPAdapterInterstitialAdClosed:self];
    }
}

- (void)interstitialDidExpire:(MPInterstitialAdController *)interstitial
{
    NSLog(@"interstitialDidExpire : %@", interstitial);
}

- (void)interstitialDidReceiveTapEvent:(MPInterstitialAdController *)interstitial
{
    NSLog(@"interstitialDidReceiveTapEvent : %@", interstitial);
    if ([_delegate respondsToSelector:@selector(AdPopcornSSPAdapterInterstitialAdClicked:)])
    {
        [_delegate AdPopcornSSPAdapterInterstitialAdClicked:self];
    }
}

- (void)clearNativeAd
{
    if(mopubNativeAdRenderer != nil && mopubNativeAdRenderer.apMopubNativeView != nil)
        [mopubNativeAdRenderer.apMopubNativeView removeFromSuperview];
    _nativeAd = nil;
}

- (void)showNativeAd
{
    if(mopubNativeAdRenderer != nil && mopubNativeAdRenderer.apMopubNativeView != nil)
        [mopubNativeAdRenderer.apMopubNativeView removeFromSuperview];
    
    UIView *adView = [_nativeAd retrieveAdViewWithError:nil];
    
    [mopubNativeAdRenderer.apMopubNativeView addSubview:adView];
    [_adpopcornSSPNativeAd addSubview:mopubNativeAdRenderer.apMopubNativeView];
    adView.frame = mopubNativeAdRenderer.apMopubNativeView.bounds;
    
    if ([_delegate respondsToSelector:@selector(AdPopcornSSPAdapterNativeAdLoadSuccess:)])
    {
        [_delegate AdPopcornSSPAdapterNativeAdLoadSuccess:self];
    }
}

#pragma mark - MPNativeAdDelegate
- (void)willPresentModalForNativeAd:(MPNativeAd *)nativeAd
{
    NSLog(@"Will present modal for native ad.");
    if ([_delegate respondsToSelector:@selector(AdPopcornSSPAdapterNativeAdClicked:)])
    {
        [_delegate AdPopcornSSPAdapterNativeAdClicked:self];
    }
}

- (void)didDismissModalForNativeAd:(MPNativeAd *)nativeAd
{
    NSLog(@"Did dismiss modal for native ad.");
}

- (void)willLeaveApplicationFromNativeAd:(MPNativeAd *)nativeAd
{
    NSLog(@"Will leave application from native ad.");
}
@end

@implementation APMoPubNativeAdRenderer
{
    
}
@end
