//
//  AdPopcornSSPAdapterConfiguration.m
//  AdPopcornSSP
//
//  Created by 김민석 on 2021/10/20.
//  Copyright © 2021 AdPopcorn. All rights reserved.
//

#import "AdPopcornSSPAdapterConfiguration.h"
#import "AdPopcornSSP.h"

@implementation AdPopcornSSPAdapterConfiguration

#pragma mark - Required MPBaseAdapterConfiguration Overrides

/// The version of the adapter.
- (NSString *)adapterVersion {
    return @"1.0.0.0";
}

/// An optional identity token used for ORTB bidding requests required for Advanced Bidding.
- (NSString * _Nullable)biddingToken {
    // Some networks require their SDK to be initialized before obtaining an
    // Advanced Bidding token. In those cases, this should return `nil`.
    return nil;
}

/// MoPub-specific name of the network.
/// @remarks This value should correspond to `creative_network_name` in the dashboard.
- (NSString *)moPubNetworkName {
    return @"adpopcornssp";
}

/// The version of the underlying network SDK.
- (NSString *)networkSdkVersion {
    NSString *sdkVersion = [AdPopcornSSP getSDKVersion];
    sdkVersion = [sdkVersion stringByReplacingOccurrencesOfString:@"in" withString:@""];
    return sdkVersion;
}

/// Initializes the underlying network SDK with a given set of initialization parameters.
/// @param configuration Optional set of JSON-codable configuration parameters that correspond specifically to the network.
///                     Only @c NSString, @c NSNumber, @c NSArray, and @c NSDictionary types are allowed.
///                     This value may be @c nil.
/// @param complete Optional completion block that is invoked when the underlying network SDK has completed initialization. This value may be @c nil.
/// @remarks Classes that implement this protocol must account for the possibility of @c initializeNetworkWithConfiguration:complete: being
///          called multiple times. It is up to each individual adapter to determine whether re-initialization is allowed or not.
- (void)initializeNetworkWithConfiguration:(NSDictionary<NSString *, id> * _Nullable)configuration complete:(void(^ _Nullable)(NSError * _Nullable))complete {
    // Check if network SDK has already been initialized before continuing.
    // Complete immediately with no error if it's already initialized.
    if (complete != nil) {
        complete(nil);
    }
    return;
}
@end
