//
//  AdPopcornSSPInterstitialAdapter.m
//  AdPopcornSSP
//
//  Created by 김민석 on 2021/10/21.
//  Copyright © 2021 AdPopcorn. All rights reserved.
//

#import "AdPopcornSSPInterstitialAdapter.h"
#import "AdPopcornSSPInterstitialAd.h"

@interface AdPopcornSSPInterstitialAdapter() <APSSPInterstitialAdDelegate>
@property (nonatomic, strong) AdPopcornSSPInterstitialAd *sspInterstitialAd;

@end

@implementation AdPopcornSSPInterstitialAdapter
#pragma mark - Required AdPopcornSSPRewardVideoAdapter Implementation

@dynamic delegate;
@dynamic localExtras;

// To opt-out of the MoPub SDK automatic impression and click counting, this method should return `NO`.
// When opted out, it is the network SDK's responsibility to track their own impressions and clicks.
- (BOOL)enableAutomaticImpressionAndClickTracking {
    return YES;
}

// Indicates whether the network SDK has an ad available now.
- (BOOL)hasAdAvailable {
    return YES;
}

- (BOOL)isRewardExpected {
    // For networks that have distinct rewarded vs non-rewarded fullscreen
    // APIs, this can be hard-coded to `YES` or `NO`.
    return NO;
}

// Ad load entry point.
- (void)requestAdWithAdapterInfo:(NSDictionary *)info adMarkup:(NSString * _Nullable)adMarkup {
    // `info` contains a combination of MoPubSDK passed in information and
    // network SDK-sepcific information from the MoPub UI. Parse out the information
    // that is needed to create the appropriate network SDK classes.
    // One example is provided below showing logic to determine if the fullscreen ad is rewarded
    // or not.
    
    // Retrieve the placement
    NSString *appKey = info[@"appKey"];
    NSString *placementId = info[@"placementId"];
    NSLog(@"AdPopcornSSPRewardVideoAdapter appkey : %@, placementid : %@", appKey, placementId);
    // Initialize an instance of the network SDK's fullscreen ad.
    _sspInterstitialAd = [[AdPopcornSSPInterstitialAd alloc] initWithKey:appKey placementId:placementId viewController:nil];
    _sspInterstitialAd.delegate = self;
    
    // Load the ad.
    [_sspInterstitialAd loadRequest];
}

// Ad show entry point.
- (void)presentAdFromViewController:(UIViewController *)viewController {
    // Check that there is an ad available, or else signal back an error to show.
    if (self.hasAdAvailable == NO) {
        NSError *error = [NSError errorWithDomain:@"com.mopub-ios-mediation.AdPopcornSSPInterstitialAdapter" code:-1 userInfo:nil];
        [self.delegate fullscreenAdAdapter:self didFailToShowAdWithError:error];
        return;
    }
    
    // Show the available ad.
    [_sspInterstitialAd presentFromViewController:viewController];
}

#pragma mark - APSSPRewardVideoAdDelegate
- (void)APSSPInterstitialAdLoadSuccess:(AdPopcornSSPInterstitialAd *)interstitialAd
{
    NSLog(@"AdPopcornSSPInterstitialAdapter APSSPInterstitialAdLoadSuccess");
}

- (void)APSSPInterstitialAdLoadFail:(AdPopcornSSPInterstitialAd *)interstitialAd error:(AdPopcornSSPError *)error
{
    NSLog(@"AdPopcornSSPInterstitialAdapter APSSPInterstitialAdLoadFail");
}

- (void)APSSPInterstitialAdClosed:(AdPopcornSSPInterstitialAd *)interstitialAd
{
    NSLog(@"AdPopcornSSPInterstitialAdapter APSSPInterstitialAdClosed");
}

- (void)APSSPInterstitialAdClicked:(AdPopcornSSPInterstitialAd *)interstitialAd
{
    NSLog(@"AdPopcornSSPInterstitialAdapter APSSPInterstitialAdClicked");
}

- (void)APSSPInterstitialAdShowSuccess:(AdPopcornSSPInterstitialAd *)interstitialAd
{
    NSLog(@"AdPopcornSSPInterstitialAdapter APSSPInterstitialAdShowSuccess");
}

- (void)APSSPInterstitialAdShowFail:(AdPopcornSSPInterstitialAd *)interstitialAd error:(AdPopcornSSPError *)error
{
    NSLog(@"AdPopcornSSPInterstitialAdapter APSSPInterstitialAdShowFail");
}
@end
