//
//  AdPopcornSSPInterstitialVideoAdapter.m
//  AdPopcornSSP
//
//  Created by 김민석 on 2021/10/21.
//  Copyright © 2021 AdPopcorn. All rights reserved.
//

#import "AdPopcornSSPInterstitialVideoAdapter.h"
#import "AdPopcornSSPInterstitialVideoAd.h"

@interface AdPopcornSSPInterstitialVideoAdapter() <APSSPInterstitialVideoAdDelegate>
@property (nonatomic, strong) AdPopcornSSPInterstitialVideoAd *sspInterstitialVideoAd;

@end

@implementation AdPopcornSSPInterstitialVideoAdapter
#pragma mark - Required AdPopcornSSPRewardVideoAdapter Implementation

@dynamic delegate;
@dynamic localExtras;

// To opt-out of the MoPub SDK automatic impression and click counting, this method should return `NO`.
// When opted out, it is the network SDK's responsibility to track their own impressions and clicks.
- (BOOL)enableAutomaticImpressionAndClickTracking {
    return YES;
}

// Indicates whether the network SDK has an ad available now.
- (BOOL)hasAdAvailable {
    return [_sspInterstitialVideoAd isReady];
}

- (BOOL)isRewardExpected {
    // For networks that have distinct rewarded vs non-rewarded fullscreen
    // APIs, this can be hard-coded to `YES` or `NO`.
    return NO;
}

// Ad load entry point.
- (void)requestAdWithAdapterInfo:(NSDictionary *)info adMarkup:(NSString * _Nullable)adMarkup {
    // `info` contains a combination of MoPubSDK passed in information and
    // network SDK-sepcific information from the MoPub UI. Parse out the information
    // that is needed to create the appropriate network SDK classes.
    // One example is provided below showing logic to determine if the fullscreen ad is rewarded
    // or not.
    
    // Retrieve the placement
    NSString *appKey = info[@"appKey"];
    NSString *placementId = info[@"placementId"];
    NSLog(@"AdPopcornSSPInterstitialVideoAdapter appkey : %@, placementid : %@", appKey, placementId);
    // Initialize an instance of the network SDK's fullscreen ad.
    _sspInterstitialVideoAd = [[AdPopcornSSPInterstitialVideoAd alloc] initWithKey:appKey placementId:placementId viewController:nil];
    _sspInterstitialVideoAd.delegate = self;
    
    // Load the ad.
    [_sspInterstitialVideoAd loadRequest];
}

// Ad show entry point.
- (void)presentAdFromViewController:(UIViewController *)viewController {
    // Check that there is an ad available, or else signal back an error to show.
    if (self.hasAdAvailable == NO) {
        NSError *error = [NSError errorWithDomain:@"com.mopub-ios-mediation.AdPopcornSSPInterstitialVideoAdapter" code:-1 userInfo:nil];
        [self.delegate fullscreenAdAdapter:self didFailToShowAdWithError:error];
        return;
    }
    
    // Show the available ad.
    [_sspInterstitialVideoAd presentFromViewController:viewController];
}

#pragma mark - APSSPInterstitialVideoAdDelegate
- (void)APSSPInterstitialVideoAdLoadSuccess:(AdPopcornSSPInterstitialVideoAd *)interstitialVideoAd
{
    NSLog(@"AdPopcornSSPInterstitialVideoAdapter APSSPInterstitialVideoAdLoadSuccess");
}

- (void)APSSPInterstitialVideoAdLoadFail:(AdPopcornSSPInterstitialVideoAd *)interstitialVideoAd error:(AdPopcornSSPError *)error
{
    NSLog(@"AdPopcornSSPInterstitialVideoAdapter APSSPInterstitialVideoAdLoadFail");
}

- (void)APSSPInterstitialVideoAdShowSuccess:(AdPopcornSSPInterstitialVideoAd *)interstitialVideoAd
{
    NSLog(@"AdPopcornSSPInterstitialVideoAdapter APSSPInterstitialVideoAdShowSuccess");
}

- (void)APSSPInterstitialVideoAdShowFail:(AdPopcornSSPInterstitialVideoAd *)interstitialVideoAd
{
    NSLog(@"AdPopcornSSPInterstitialVideoAdapter APSSPInterstitialVideoAdShowFail");
}

- (void)APSSPInterstitialVideoAdClosed:(AdPopcornSSPInterstitialVideoAd *)interstitialVideoAd
{
    NSLog(@"AdPopcornSSPInterstitialVideoAdapter APSSPInterstitialVideoAdClosed");
}
@end
