//
//  AdPopcornSSPRewardVideoAdapter.m
//  AdPopcornSSP
//
//  Created by 김민석 on 2021/10/20.
//  Copyright © 2021 AdPopcorn. All rights reserved.
//

#import "AdPopcornSSPRewardVideoAdapter.h"
#import "AdPopcornSSPRewardVideoAd.h"

@interface AdPopcornSSPRewardVideoAdapter() <APSSPRewardVideoAdDelegate>
@property (nonatomic, strong) AdPopcornSSPRewardVideoAd *sspRewardVideoAd;

@end

@implementation AdPopcornSSPRewardVideoAdapter


#pragma mark - Required AdPopcornSSPRewardVideoAdapter Implementation

@dynamic delegate;
@dynamic localExtras;

// To opt-out of the MoPub SDK automatic impression and click counting, this method should return `NO`.
// When opted out, it is the network SDK's responsibility to track their own impressions and clicks.
- (BOOL)enableAutomaticImpressionAndClickTracking {
    return YES;
}

// Indicates whether the network SDK has an ad available now.
- (BOOL)hasAdAvailable {
    return [_sspRewardVideoAd isReady];
}

- (BOOL)isRewardExpected {
    // For networks that have distinct rewarded vs non-rewarded fullscreen
    // APIs, this can be hard-coded to `YES` or `NO`.
    return YES;
}

// Ad load entry point.
- (void)requestAdWithAdapterInfo:(NSDictionary *)info adMarkup:(NSString * _Nullable)adMarkup {
    // `info` contains a combination of MoPubSDK passed in information and
    // network SDK-sepcific information from the MoPub UI. Parse out the information
    // that is needed to create the appropriate network SDK classes.
    // One example is provided below showing logic to determine if the fullscreen ad is rewarded
    // or not.
    
    // Retrieve the placement
    NSString *appKey = info[@"appKey"];
    NSString *placementId = info[@"placementId"];
    NSLog(@"AdPopcornSSPRewardVideoAdapter appkey : %@, placementid : %@", appKey, placementId);
    // Initialize an instance of the network SDK's fullscreen ad.
    _sspRewardVideoAd = [[AdPopcornSSPRewardVideoAd alloc] initWithKey:appKey placementId:placementId viewController:nil];
    _sspRewardVideoAd.delegate = self;
    
    // Load the ad.
    [_sspRewardVideoAd loadRequest];
}

// Ad show entry point.
- (void)presentAdFromViewController:(UIViewController *)viewController {
    // Check that there is an ad available, or else signal back an error to show.
    if (self.hasAdAvailable == NO) {
        NSError *error = [NSError errorWithDomain:@"com.mopub-ios-mediation.AdPopcornSSPRewardVideoAdapter" code:-1 userInfo:nil];
        [self.delegate fullscreenAdAdapter:self didFailToShowAdWithError:error];
        return;
    }
    
    // Show the available ad.
    [_sspRewardVideoAd presentFromViewController:viewController];
}

#pragma mark - APSSPRewardVideoAdDelegate
- (void)APSSPRewardVideoAdLoadSuccess:(AdPopcornSSPRewardVideoAd *) rewardVideoAd
{
    NSLog(@"AdPopcornSSPRewardVideoAdapter APSSPRewardVideoAdLoadSuccess");
    [self.delegate fullscreenAdAdapterDidLoadAd:self];
}

- (void)APSSPRewardVideoAdLoadFail:(AdPopcornSSPRewardVideoAd *) rewardVideoAd error:(AdPopcornSSPError *)error
{
    NSLog(@"AdPopcornSSPRewardVideoAdapter APSSPRewardVideoAdLoadFail : %@", error);
    [self.delegate fullscreenAdAdapter:self didFailToLoadAdWithError:error];
}
- (void)APSSPRewardVideoAdShowSuccess:(AdPopcornSSPRewardVideoAd *) rewardVideoAd
{
    NSLog(@"AdPopcornSSPRewardVideoAdapter APSSPRewardVideoAdShowSuccess");
    [self.delegate fullscreenAdAdapterAdDidPresent:self];
}
- (void)APSSPRewardVideoAdShowFail:(AdPopcornSSPRewardVideoAd *)rewardVideoAd
{
    NSLog(@"AdPopcornSSPRewardVideoAdapter APSSPRewardVideoAdShowFail");
    [self.delegate fullscreenAdAdapter:self didFailToShowAdWithError:nil];
}
- (void)APSSPRewardVideoAdClosed:(AdPopcornSSPRewardVideoAd *)rewardVideoAd
{
    NSLog(@"AdPopcornSSPRewardVideoAdapter APSSPRewardVideoAdClosed");
    [self.delegate fullscreenAdAdapterAdDidDisappear:self];
    [self.delegate fullscreenAdAdapterAdDidDismiss:self];
}

- (void)APSSPRewardVideoAdPlayCompleted:(AdPopcornSSPRewardVideoAd *)rewardVideoAd adNetworkNo:(long)adNetworkNo completed:(BOOL)completed
{
    NSLog(@"AdPopcornSSPRewardVideoAdapter APSSPRewardVideoAdPlayCompleted : %ld, isCompleted : %d", adNetworkNo, completed);
    // Most mediation networks do not have an SDK API reward selection
    // mechanism since it is typically handled server side or in the
    // MoPub UI.
    // In these cases we use `kMPRewardCurrencyAmountUnspecified`.
    if(completed)
    {
        MPReward *reward = [[MPReward alloc] initWithCurrencyAmount:@(kMPRewardCurrencyAmountUnspecified)];
        [self.delegate fullscreenAdAdapter:self willRewardUser:reward];
    }
}
@end
