//
//  TapJoyAdapter.m
//  AdPopcornSSP
//
//  Created by mick on 2020. 10. 28..
//  Copyright (c) 2020년 igaworks All rights reserved.
//

// compatible with TapJoy v12.7.0
#import "TapJoyAdapter.h"

static inline NSString *SSPErrorString(SSPErrorCode code)
{
    switch (code)
    {
        case AdPopcornSSPException:
            return @"Exception";
        case AdPopcornSSPInvalidParameter:
            return @"Invalid Parameter";
        case AdPopcornSSPUnknownServerError:
            return @"Unknown Server Error";
        case AdPopcornSSPInvalidMediaKey:
            return @"Invalid Media key";
        case AdPopcornSSPInvalidPlacementId:
            return @"Invalid Placement Id";
        case AdPopcornSSPInvalidNativeAssetsConfig:
            return @"Invalid native assets config";
        case AdPopcornSSPNativePlacementDoesNotInitialized:
            return @"Native Placement Does Not Initialized";
        case AdPopcornSSPServerTimeout:
            return @"Server Timeout";
        case AdPopcornSSPLoadAdFailed:
            return @"Load Ad Failed";
        case AdPopcornSSPNoAd:
            return @"No Ad";
        case AdPopcornSSPNoInterstitialLoaded:
            return @"No Interstitial Loaded";
        case AdPopcornSSPNoRewardVideoAdLoaded:
            return @"No Reward video ad Loaded";
        case AdPopcornSSPMediationAdapterNotInitialized:
            return @"Mediation Adapter Not Initialized";
        case AdPopcornSSPNoInterstitialVideoAdLoaded:
            return @"No Interstitial video ad Loaded";
        default: {
            return @"Success";
        }
    }
}

@interface TapJoyAdapter () <TJPlacementDelegate, TJPlacementVideoDelegate>
{
    BOOL _isCurrentRunningAdapter;
    NSString *tapJoySDKKey, *tapJoyPlacementId;
    NSTimer *networkScheduleTimer;
    NSInteger adNetworkNo;
}

@end

@implementation TapJoyAdapter

@synthesize delegate = _delegate;
@synthesize integrationKey = _integrationKey;
@synthesize viewController = _viewController;
@synthesize bannerView = _bannerView;

- (instancetype)init
{
    self = [super init];
    if (self){}
    adNetworkNo = 17;
    return self;
}

- (void)setViewController:(UIViewController *)viewController origin:(CGPoint)origin size:(CGSize)size bannerView:(AdPopcornSSPBannerView *)bannerView
{
    _viewController = viewController;
    _origin = origin;
    _size = size;
    _bannerView = bannerView;
    _adType = SSPAdBannerType;
}

- (void)setViewController:(UIViewController *)viewController
{
    _viewController = viewController;
    _adType = SSPAdInterstitialType;
}

- (void)setRewardVideoViewController:(UIViewController *)viewController
{
    _viewController = viewController;
    _adType = SSPRewardVideoAdType;
}

- (void)setInterstitialVideoViewController:(UIViewController *)viewController
{
    _viewController = viewController;
    _adType = SSPInterstitialVideoAdType;
}

- (BOOL)isSupportInterstitialAd
{
    return NO;
}

- (BOOL)isSupportRewardVideoAd
{
    return YES;
}

- (BOOL)isSupportInterstitialVideoAd
{
    return NO;
}

- (void)loadAd
{
    if(networkScheduleTimer == nil)
    {
        networkScheduleTimer = [NSTimer scheduledTimerWithTimeInterval:10 target:self selector:@selector(networkScheduleTimeoutHandler:) userInfo:nil repeats:NO];
    }
    else{
        [self invalidateNetworkTimer];
        networkScheduleTimer = [NSTimer scheduledTimerWithTimeInterval:10 target:self selector:@selector(networkScheduleTimeoutHandler:) userInfo:nil repeats:NO];
    }
    
    if (_adType == SSPRewardVideoAdType)
    {
        NSLog(@"TapJoyAdapter %@ : SSPRewardVideoAdType loadAd", self);
        _isCurrentRunningAdapter = YES;
        if (_integrationKey != nil)
        {
            tapJoySDKKey = [_integrationKey valueForKey:@"TapJoySDKKey"];
            tapJoyPlacementId = [_integrationKey valueForKey:@"TapJoyPlacementId"];
            
            if([Tapjoy isConnected])
            {
                NSLog(@"TapJoyAdapter is already connected");
                TJPlacement *p = [TJPlacement placementWithName:tapJoyPlacementId delegate:self];
                if([p isContentReady])
                {
                    NSLog(@"TapJoyAdapter isContentReady true");
                    if (_isCurrentRunningAdapter && [_delegate respondsToSelector:@selector(AdPopcornSSPAdapterRewardVideoAdLoadSuccess:)])
                    {
                        [_delegate AdPopcornSSPAdapterRewardVideoAdLoadSuccess:self];
                    }
                    [self invalidateNetworkTimer];
                }
                else
                {
                    NSLog(@"TapJoyAdapter isContentReady false");
                    [p requestContent];
                }
            }
            else
            {
                NSLog(@"TapJoyAdapter try connect");
                [Tapjoy connect:tapJoySDKKey];
                TJPlacement *p = [TJPlacement placementWithName:tapJoyPlacementId delegate:self];
                [p requestContent];
            }
        }
        else
        {
            NSLog(@"TapJoyAdapter rv no integrationKey");
            if (_isCurrentRunningAdapter && [_delegate respondsToSelector:@selector(AdPopcornSSPAdapterRewardVideoAdLoadFailError:adapter:)])
            {
                [_delegate AdPopcornSSPAdapterRewardVideoAdLoadFailError:[NSError errorWithDomain:kAdPopcornSSPErrorDomain code:AdPopcornSSPMediationInvalidIntegrationKey userInfo:@{NSLocalizedDescriptionKey: SSPErrorString(AdPopcornSSPMediationInvalidIntegrationKey)}] adapter:self];
            }
            [self invalidateNetworkTimer];
        }
    }
}

- (void)showAd
{
    NSLog(@"TapJoyAdapter : showAd");
    if (_adType == SSPRewardVideoAdType)
    {
        TJPlacement *p = [TJPlacement placementWithName:tapJoyPlacementId delegate:self];
        if(p.isContentReady) {
           [p showContentWithViewController: _viewController];
        }
        else {
            if (_isCurrentRunningAdapter && [_delegate respondsToSelector:@selector(AdPopcornSSPAdapterRewardVideoAdShowFailError:adapter:)])
            {
                [_delegate AdPopcornSSPAdapterRewardVideoAdShowFailError:[NSError errorWithDomain:kAdPopcornSSPErrorDomain code:AdPopcornSSPNoRewardVideoAdLoaded userInfo:@{NSLocalizedDescriptionKey: SSPErrorString(AdPopcornSSPNoRewardVideoAdLoaded)}] adapter:self];
            }
        }
    }
}

- (void)closeAd
{
    NSLog(@"TapJoyAdapter closeAd");
    _isCurrentRunningAdapter = NO;
}

- (void)loadRequest
{
    // Not used any more
}

-(void)networkScheduleTimeoutHandler:(NSTimer*) timer
{
    if(_adType == SSPRewardVideoAdType)
    {
        NSLog(@"TapJoyAdapter rv load timeout");
        if (_isCurrentRunningAdapter && [_delegate respondsToSelector:@selector(AdPopcornSSPAdapterRewardVideoAdLoadFailError:adapter:)])
        {
            [_delegate AdPopcornSSPAdapterRewardVideoAdLoadFailError:[NSError errorWithDomain:kAdPopcornSSPErrorDomain code:AdPopcornSSPLoadAdFailed userInfo:@{NSLocalizedDescriptionKey: SSPErrorString(AdPopcornSSPLoadAdFailed)}] adapter:self];
        }
    }
    [self invalidateNetworkTimer];
}

-(void)invalidateNetworkTimer
{
    if(networkScheduleTimer != nil)
        [networkScheduleTimer invalidate];
}

#pragma mark TJPlacementDelegate
// Called when the content request returns from Tapjoy's servers. Does not necessarily mean that content is available.
- (void)requestDidSucceed:(TJPlacement*)placement
{
    NSLog(@"TapJoyAdapter requestDidSucceed");
}

- (void)requestDidFail:(TJPlacement*)placement error:(NSError*)error
{
    NSLog(@"TapJoyAdapter requestDidFail");
    if (_isCurrentRunningAdapter && [_delegate respondsToSelector:@selector(AdPopcornSSPAdapterRewardVideoAdLoadFailError:adapter:)])
    {
        [_delegate AdPopcornSSPAdapterRewardVideoAdLoadFailError:[NSError errorWithDomain:kAdPopcornSSPErrorDomain code:AdPopcornSSPLoadAdFailed userInfo:@{NSLocalizedDescriptionKey: SSPErrorString(AdPopcornSSPLoadAdFailed)}] adapter:self];
    }
    [self invalidateNetworkTimer];
}

//This is called when the content is actually available to display.
- (void)contentIsReady:(TJPlacement*)placement
{
    NSLog(@"TapJoyAdapter contentIsReady");
    if (_isCurrentRunningAdapter && [_delegate respondsToSelector:@selector(AdPopcornSSPAdapterRewardVideoAdLoadSuccess:)])
    {
        [_delegate AdPopcornSSPAdapterRewardVideoAdLoadSuccess:self];
    }
    [self invalidateNetworkTimer];
}

- (void)contentDidAppear:(TJPlacement*)placement
{
    NSLog(@"TapJoyAdapter contentDidAppear");
    if (_isCurrentRunningAdapter && [_delegate respondsToSelector:@selector(AdPopcornSSPAdapterRewardVideoAdShowSuccess:)])
    {
        [_delegate AdPopcornSSPAdapterRewardVideoAdShowSuccess:self];
    }
    if(placement != nil)
        placement.videoDelegate = self;
}

- (void)contentDidDisappear:(TJPlacement*)placement
{
    NSLog(@"TapJoyAdapter contentDidDisappear");
    if ([_delegate respondsToSelector:@selector(AdPopcornSSPAdapterRewardVideoAdClose:)])
    {
        [_delegate AdPopcornSSPAdapterRewardVideoAdClose:self];
    }
    _isCurrentRunningAdapter = NO;
}

#pragma mark TJPlacementVideoDelegate
- (void)videoDidStart:(TJPlacement*)placement
{
    NSLog(@"TapJoyAdapter videoDidStart");
}

- (void)videoDidComplete:(TJPlacement*)placement
{
    NSLog(@"TapJoyAdapter videoDidComplete");
    if ([_delegate respondsToSelector:@selector(onCompleteTrackingEvent:isCompleted:)])
    {
        [_delegate onCompleteTrackingEvent:adNetworkNo isCompleted:YES];
    }
}

- (void)videoDidFail:(TJPlacement*)placement error:(NSString*)errorMsg
{
    NSLog(@"TapJoyAdapter videoDidFail");
}
@end
