#!/usr/bin/env python3
# -*- coding: utf-8 -*-

from Commands.PythonCommandBase import PythonCommand, ImageProcPythonCommand
from Commands.Keys import KeyPress, Button, Direction, Stick, Hat
import time

class SVraid(ImageProcPythonCommand):
    NAME = 'SV_レイドコレクレー厳選_v.1.5_KUMA'

    def __init__(self,cam):
        super().__init__(cam)

    def do(self):
        print("-------------------------------")
        print("SV コレクレーレイド_v.1.5kuma")
        print("Developed by.じゃんきー")
        print("Special Thanks:フウさん（爆速になりました）")
        print("はんぺんさん、特にさん、minahokuさん、こちゃてすさん、れじさん、にしおさん、えび＠さん、PokeTSVさん、ジュナリさん")
        print("-------------------------------")
        self.wait(0.5)
        ev_count = 0
        ev_star3 = 0
        ev_star4 = 0
        ev_star5 = 0
        raid_count = 1
        day_count = 1
        win = 0
        lose = 0
        reset_count = 0
        time_raid_elp0 = 0
        time_sta = time.time()
        print("Start")

        #事前設定
        #ニックネーム設定：OFF
        #ボックスは自動で送らない設定
        #オートセーブ：OFF
        #初回は巣穴の正面に立って実施。場所がわかってればその場でOK。
        #レイド終了後、主人公が北を向くので北を向いて参加できる巣穴
        #ボール変更の処理は入れてません

        #注意事項！！！
        #ボールがなくなった時の処理は入れてません。ご注意ください。
        #ボールの変更処理も入れてません。A連打でボールを投げます

        while True:
            self.wait(0.5)
            #メニュー認識
            while not self.isContainTemplate('SV_suana/menu_R.png', threshold=0.8, use_gray=True, show_value=False):
                self.press(Button.X, wait=1.0)
            self.wait(0.2)
            self.press(Button.B, wait=0.2)
            while self.isContainTemplate('SV_suana/menu_R.png', threshold=0.8, use_gray=True, show_value=False):
                self.wait(0.1)
            self.wait(0.15)
            print("メニュー画面を認識しました")
            self.press(Button.A, wait=1.5)
            while not self.isContainTemplate('SV_suana/star5_korekure.png', threshold=0.9, use_gray=False, show_value=False):
                if self.isContainTemplate('SV_suana/raid.png', threshold=0.9, use_gray=True, show_value=False):
                    #巣穴数
                    raid_count += 1
                    #イベントレイド数
                    if self.isContainTemplate('SV_suana/korekure.png', threshold=0.9, use_gray=False, show_value=False):
                        #イベントレイド★3
                        if self.isContainTemplate('SV_suana/ev_star4.png', threshold=0.92, use_gray=False, show_value=False):
                            ev_star4 += 1
                            print("巣穴発見 : ",raid_count-1,"回  ★4コレクレー")
                        else:
                            ev_star3 +=1
                            print("巣穴発見 : ",raid_count-1,"回  ★3コレクレー")
                    else:
                        print("巣穴発見 : ",raid_count-1,"回")
                    self.wait(0.8)
                    self.press(Button.B, wait=0.4)
                #日付変更
                self.press(Button.X, wait=0.6)
                while not self.isContainTemplate('SV_suana/menu_R.png', threshold=0.8, use_gray=True, show_value=False):
                    self.press(Button.X, wait=1.0)
                    if self.isContainTemplate('SV_suana/raid.png', threshold=0.9, use_gray=True, show_value=False):
                        self.press(Button.B, wait=0.8)
                self.press(Button.HOME, wait=0.4)
                while not self.isContainTemplate('SV_suana/switch_menu.png', threshold=0.8, use_gray=True, show_value=False):
                    self.wait(0.1)
                self.wait(0.1)
                self.quickDateChange()
                while not self.isContainTemplate('SV_suana/switch_menu.png', threshold=0.8, use_gray=True, show_value=False):
                    self.wait(0.1)
                self.wait(0.05)
                self.press(Button.HOME, wait=0.4)
                day_count += 1
                #巣穴わき待機
                while not self.isContainTemplate('SV_suana/menu_R.png', threshold=0.8, use_gray=True, show_value=False):
                    self.wait(0.1)
                self.wait(0.3)
                self.press(Button.X, wait=0.6)
                self.press(Button.A, wait=1.0)
                
            print("★5コレクレー発見")
            ev_star5 += 1
            self.press(Button.B, wait=1.5)
            self.press(Button.X, wait=1.5)
            self.press(Button.R, wait=1.0)#レポート
            self.press(Button.A, wait=4.0)#レポート待機時間
            self.press(Button.B, wait=1.0)
            self.press(Button.B, wait=1.0)
            #レイド参加
            self.press(Button.A, wait=4.0)
            self.press(Direction.DOWN, wait=1.0)
            self.press(Button.A, wait=1.0)
            self.press(Button.A, wait=1.0)#入力抜け防止

            #レイド参加
            print("------------レイド開始-------------")
            print(" ",ev_star5,"回目   戦績：",win,"勝",lose,"敗")
            print("----------------------------------")
            self.press(Button.A, wait=4.0)
            #つかまえたが出るまで
            print("倒すまでの処理を実施します")
            time_raid_sta0 = time.time()
            while not self.isContainTemplate('SV_suana/raid_catch2.png', threshold=0.92, use_gray=False, show_value=False):
                self.wait(1.0)
                #リングマでバトル
                self.ringuma()
                if self.isContainTemplate('SV_suana/raid_lose.png', threshold=0.9, use_gray=True, show_value=False):
                    print("負けたためフィールドに戻ります")
                    self.press(Button.B, wait=1.0)
                    lose += 1
                    break
                #ソフトリセット処理
                time_raid_elp0 = time.time() - time_raid_sta0
                if time_raid_elp0 > 470:
                    print("ソフトをリセットします")
                    self.softreset()
                    reset_count += 1
                    raid_count -= 1
                    ev_star5 -= 1
                    break
            if time_raid_elp0 > 470:
                continue
            if self.isContainTemplate('SV_suana/raid_lose.png', threshold=0.9, use_gray=True, show_value=False):
                print("敗北したため、再戦します")
                continue
            while not self.isContainTemplate('SV_suana/raid_catch.png', threshold=0.8, use_gray=False, show_value=False):
                self.press(Direction.UP, wait=1.0)
            print("捕獲マークを認識。捕獲します。")
            win += 1
            self.wait(2.0)
            self.press(Button.A, wait=1.0)
            self.press(Button.A, wait=1.0)
            #強さを見るまで待機
            #つぎへのAボタン認識するまで待機
            while not self.isContainTemplate('SV_suana/raid_A.png', threshold=0.8, use_gray=False, show_value=False):
                self.wait(0.5)
            print("捕獲を確認しました")
            self.wait(2.0)
            self.press(Button.A, wait=1.0)
            self.press(Button.A, wait=1.0)
            #強さを見るまで待機
            while not self.isContainTemplate('SV_suana/temochi.png', threshold=0.8, use_gray=False, show_value=False):
                self.wait(0.3)
                if self.isContainTemplate('SV_suana/triangle.png', threshold=0.8, use_gray=True, show_value=False):
                    self.press(Button.B, wait=1.0)
            #色違い確認
            self.wait(3.0)
            self.press(Direction.DOWN, wait=1.0)
            self.press(Button.A, wait=1.0)
            while not self.isContainTemplate('SV_suana/status.png', threshold=0.8, use_gray=False, show_value=False):
                self.wait(0.5)
            print("ポケモンステータス画面確認完了")
            self.wait(2.0)
            if self.isContainTemplate('SV_suana/shiny_mark.png', threshold=0.8, use_gray=True, show_value=False):
                print("色違いが出たためプログラム終了")
                self.finish()
            print("色違いではありませんでした")
            self.press(Button.B, wait=1.0)
            self.press(Button.B, wait=1.0)
            self.press(Button.A, wait=0.5)
            self.press(Button.A, wait=0.5)
            #結果表示
            suana_rate = raid_count / day_count *100
            koreku_rate = ev_star5 / raid_count *100
            ev_count = ev_star3 + ev_star4 + ev_star5
            ev_star5_rate = ev_star5 / ev_count *100
            ev_star4_rate = ev_star4 / ev_count *100
            ev_star3_rate = ev_star3 / ev_count *100
            time_end = time.time()
            TIME = time_end - time_sta
            print("------------レイド終了-------------")
            print(" ")
            print(" 日付変更数           :",day_count - 1,"回")
            print(" 巣穴発見数           :",raid_count - 1,"回")
            print(" 巣穴発見率           :",round(suana_rate,2),"%")
            print(" ★５コレクレー発見数 :",ev_star5,"回")
            print(" ★５コレクレー発見率 :",round(koreku_rate,2),"%")
            print(" ")
            print(" イベントレイド内の比率")
            print("  ★5 :",ev_star5,"回  ",round(ev_star5_rate,2),"%",)
            print("  ★4 :",ev_star4,"回  ",round(ev_star4_rate,2),"%",)
            print("  ★3 :",ev_star3,"回  ",round(ev_star3_rate,2),"%",)
            print(" ")
            print(' プログラム稼働時間   :' + str(int((TIME / 3600) % 24)) + '時間' + str(int((TIME / 60) % 60)) + '分' + str(int(TIME % 60)) + '秒')
            #if reset_count >= 1:
            print(" リセット回数",reset_count,"回")
            print("----------------------------------")

    def ringuma(self):
        time_raid_sta = time.time()
        print("はらだいこリングマ")
        #初手はらだいこ
        while not self.isContainTemplate('SV_suana/haradaiko.png', threshold=0.92, use_gray=False, show_value=False):
            self.press(Button.A, wait=0.5)
        self.press(Button.A, wait=0.5)
        self.press(Button.A, wait=0.5)
        self.press(Button.A, wait=0.5)
        self.press(Button.A, wait=0.5)
        print("はらだいこ済")
        while not self.isContainTemplate('SV_suana/raid_catch2.png', threshold=0.9, use_gray=False, show_value=False):
            self.wait(0.5)
            #経過時間でリセット
            time_raid_elp = time.time() - time_raid_sta
            if time_raid_elp > 480:
                print("レイド継続判定が8分以上続いています")
                break
            #対戦処理
            if self.isContainTemplate('SV_suana/raid_support.png', threshold=0.85, use_gray=False, show_value=False):
                self.press(Direction.UP, wait=0.15)
            if self.isContainTemplate('SV_suana/raid_run.png', threshold=0.85, use_gray=False, show_value=False):
                self.press(Direction.DOWN, wait=0.15)
            if self.isContainTemplate('SV_suana/raid_battle.png', threshold=0.85, use_gray=False, show_value=False):
                self.wait(2.5)
                self.press(Button.A, wait=1.0)
                for n in range(4):
                    if self.isContainTemplate("SV_Suana/critical.png", threshold=0.85, use_gray=False, show_value=False):
                        print("効果抜群あり")
                        self.wait(0.2)
                        break
                    self.press(Direction.DOWN, wait=0.2)
                for i in range(4):
                    if self.isContainTemplate("SV_Suana/critical.png", threshold=0.85, use_gray=False, show_value=False):
                        self.press(Button.A, wait=0.5)
                        print("効果抜群で攻撃")
                        break
                    if self.isContainTemplate("SV_Suana/karagenki.png", threshold=0.85, use_gray=False, show_value=False):
                        self.press(Button.A, wait=0.2)
                        print("からげんきで攻撃")
                        break
                    self.press(Direction.DOWN, wait=0.3)
                self.press(Button.A, wait=0.5)
                self.press(Button.A, wait=0.5)
                if self.isContainTemplate("SV_Suana/raid_keepon_B.png", threshold=0.93, use_gray=False, show_value=False)\
                or self.isContainTemplate("SV_suana/raid_keepon_nomal.png", threshold=0.9, use_gray=False, show_value=False):
                    self.press(Button.A, wait=0.5)
                    self.press(Button.A, wait=0.5)
                    self.press(Button.A, wait=0.5)
                if self.isContainTemplate('SV_suana/raid_lose.png', threshold=0.9, use_gray=True, show_value=False)\
                or self.isContainTemplate("SV_suana/raid_catch.png", threshold=0.9, use_gray=False, show_value=False):
                    break
            if self.isContainTemplate('SV_suana/raid_lose.png', threshold=0.9, use_gray=True, show_value=False):
                print("敗北")
                break
            self.press(Button.B, wait=0.5) #復帰用
            self.press(Button.B, wait=0.5) #復帰用
            self.press(Button.B, wait=0.5) #復帰用

    def sendCommand(self, row: str, wait: float = 0.04):
        self.keys.ser.ser.write((row + '\r\n').encode('utf-8'))
        time.sleep(wait)
        self.checkIfAlive()

    def quickDateChange(self):
        Neutral      = "0x0003 8 80 80 80 80"   # NEUTRAL
        Button_A     = "0x0013 8 80 80 80 80"   # A
        Home         = "0x4000 8 80 80 80 80"   # HOME
        Lstick_down  = "0x0003 8 80 ff 80 80"   # LSTICK-DOWN
        Rstick_down  = "0x0003 8 80 80 80 ff"   # RSTICK-DOWN
        Lstick_right = "0x0003 8 ff 80 80 80"   # LSTICK-RIGHT
        Rstick_right = "0x0003 8 80 80 ff 80"   # RSTICK-RIGHT
        Lstick_left  = "0x0003 8 00 80 80 80"   # LSTICK-LEFT
        
        # ゲーム選択画面⇒設定
        self.sendCommand(Lstick_left,  wait=0.04) 
        self.sendCommand(Neutral,      wait=0.16) # 設定画面に移動できない場合は要調整。
        self.sendCommand(Lstick_down,  wait=0.04)
        self.sendCommand(Lstick_left,  wait=0.04)
        self.sendCommand(Button_A,     wait=0.80)

        # 設定の一番下まで移動
        self.sendCommand(Lstick_down,  wait=0.04)
        self.sendCommand(Rstick_down,  wait=0.04)
        self.sendCommand(Lstick_down,  wait=0.04)
        self.sendCommand(Rstick_down,  wait=0.04)
        self.sendCommand(Lstick_down,  wait=0.04)
        self.sendCommand(Rstick_down,  wait=0.04)
        self.sendCommand(Lstick_down,  wait=0.04)
        self.sendCommand(Rstick_down,  wait=0.04)
        self.sendCommand(Lstick_down,  wait=0.04)
        self.sendCommand(Rstick_down,  wait=0.04)
        self.sendCommand(Lstick_down,  wait=0.04)
        self.sendCommand(Rstick_down,  wait=0.04)
        self.sendCommand(Lstick_down,  wait=0.04)
        self.sendCommand(Rstick_down,  wait=0.04)
        self.sendCommand(Lstick_down,  wait=0.04)
        self.sendCommand(Rstick_down,  wait=0.04)
        self.sendCommand(Button_A,     wait=0.20)

        # 日付と時刻を選択
        self.sendCommand(Lstick_down,  wait=0.04)
        self.sendCommand(Rstick_down,  wait=0.04)
        self.sendCommand(Lstick_down,  wait=0.04)
        self.sendCommand(Rstick_down,  wait=0.04)
        self.sendCommand(Lstick_down,  wait=0.04)
        self.sendCommand(Rstick_down,  wait=0.32) # カーソルが日付と時刻を選択しない場合は要調整。
        self.sendCommand(Lstick_down,  wait=0.04)
        self.sendCommand(Rstick_down,  wait=0.04)
        self.sendCommand(Button_A,     wait=0.04) 
        self.sendCommand(Neutral,      wait=0.20) # タイムゾーンを変更してしまう場合はwaitを大きくすること。

        # 現在の日付と時刻を選択
        self.sendCommand(Lstick_down,  wait=0.04)
        self.sendCommand(Rstick_down,  wait=0.04)
        self.sendCommand(Button_A,     wait=0.20) # 時刻変更でminを変更しない場合はwaitを大きくすること。

        # 時間変更画面
        self.sendCommand(Lstick_right, wait=0.04)
        self.sendCommand(Rstick_right, wait=0.04)
        self.sendCommand(Lstick_right, wait=0.04)
        self.sendCommand(Rstick_right, wait=0.04)
        self.sendCommand(Lstick_down,  wait=0.04)
        self.sendCommand(Button_A,     wait=0.04)
        self.sendCommand(Lstick_right, wait=0.04)
        self.sendCommand(Button_A,     wait=0.04)
        self.sendCommand(Neutral,      wait=0.10) # HOME画面に戻らない場合は要調整。

        # ホーム画面に戻る
        self.sendCommand(Home,         wait=0.08)
        self.sendCommand(Neutral,      wait=0.10)
        
    def softreset(self):
        self.wait(0.5)
        self.press(Button.HOME, wait=0.5)
        self.wait(0.5)
        self.press(Button.X, wait=0.5)
        self.wait(0.5)
        self.press(Button.A, wait=2.0) 
        self.press(Button.A, wait=2.0) 
        self.press(Button.A, wait=2.0) 
        while not self.isContainTemplate('SV_suana/S_TOP.png', threshold=0.8, use_gray=True, show_value=False):
            self.wait(0.5)
            self.press(Button.A, wait=1.0)
        print("TOP画面を認識しました。")
        self.wait(3.0)
        self.press(Button.A, wait=1.0)